/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javajs.util.PT;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import org.jmol.api.JmolAbstractButton;
import org.jmol.console.GenericTextArea;
import org.jmol.console.JmolConsole;
import org.jmol.console.JmolLabel;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.script.T;
import org.jmol.viewer.Viewer;

public class AppletConsole
extends JmolConsole {
    public AppletConsole() {
        this.input = new ControlEnterTextArea();
        this.output = new GenericTextPane();
    }

    @Override
    public void start(Viewer viewer) {
        this.setViewer(viewer);
        Component component = (Component)viewer.display;
        this.vwrFrame = component instanceof JFrame ? (JFrame)component : null;
        JFrame jFrame = new JFrame();
        jFrame.setSize(600, 400);
        this.externalContainer = jFrame;
        this.setLabels();
        JTextArea jTextArea = (JTextArea)((Object)this.input);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setDragEnabled(true);
        Keymap keymap = jTextArea.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 1);
        keymap.removeKeyStrokeBinding(keyStroke);
        ((JTextPane)((Object)this.output)).setEditable(false);
        ((JTextPane)((Object)this.output)).setDragEnabled(true);
        this.addWindowListener();
        this.displayConsole();
    }

    @Override
    protected JmolAbstractButton getLabel1() {
        return new JmolLabel(AppletConsole.getLabel("label1"), 0);
    }

    @Override
    protected void layoutWindow(String string) {
        JScrollPane jScrollPane = new JScrollPane((JTextArea)((Object)this.input));
        jScrollPane.setMinimumSize(new Dimension(2, 100));
        JScrollPane jScrollPane2 = new JScrollPane((JTextPane)((Object)this.output));
        jScrollPane2.setMinimumSize(new Dimension(2, 100));
        Container container = this.getPane();
        container.setLayout(new BoxLayout(container, 1));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane);
        jSplitPane.setResizeWeight(0.9);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setAlignmentX(0.5f);
        container.add(jSplitPane);
        Container container2 = new Container();
        container2.setLayout(new BoxLayout(container2, 0));
        container2.add(Box.createGlue());
        this.add(container2, this.editButton);
        this.add(container2, this.runButton);
        this.add(container2, this.loadButton);
        this.add(container2, this.clearInButton);
        this.add(container2, this.clearOutButton);
        this.add(container2, this.historyButton);
        this.add(container2, this.stateButton);
        container2.add(Box.createGlue());
        container.add(container2);
        if (this.label1 != null) {
            ((JLabel)((Object)this.label1)).setAlignmentX(0.5f);
            container.add((JLabel)((Object)this.label1));
        }
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setJMenuBar(this.createMenubar());
        }
    }

    private void add(Container container, JmolAbstractButton jmolAbstractButton) {
        container.add((JButton)((Object)jmolAbstractButton));
    }

    private JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    private void addHelpMenuBar(JMenuBar jMenuBar) {
        KeyJMenu keyJMenu = new KeyJMenu("help", AppletConsole.getLabel("help"), this.menuMap);
        JMenuItem jMenuItem = this.createMenuItem("search");
        jMenuItem.addActionListener(this);
        jMenuItem.setName("help ?search=?");
        keyJMenu.add(jMenuItem);
        this.addHelpItems(keyJMenu, "commands", "command");
        this.addHelpItems(keyJMenu, "functions", "mathfunc");
        this.addHelpItems(keyJMenu, "parameters", "setparam");
        this.addHelpItems(keyJMenu, "more", "misc");
        jMenuBar.add(keyJMenu);
    }

    private void addHelpItems(JMenu jMenu, String string, String string2) {
        KeyJMenu keyJMenu = new KeyJMenu(string, AppletConsole.getLabel(string), this.menuMap);
        String[] stringArray = T.getTokensLike(string2);
        jMenu.add(keyJMenu);
        JMenu jMenu2 = null;
        String string3 = null;
        int n = 20;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!PT.isLetter(string4.charAt(0))) continue;
            JMenuItem jMenuItem = new JMenuItem(string4);
            jMenuItem.addActionListener(this);
            jMenuItem.setName("help " + string4);
            if (jMenu2 == null) {
                jMenu2 = new JMenu();
                string3 = string4;
                jMenu2.add(jMenuItem);
                jMenu2.setText(string3);
                continue;
            }
            if (i % n + 1 == n) {
                jMenu2.add(jMenuItem);
                jMenu2.setText(string3 + " - " + string4);
                keyJMenu.add(jMenu2);
                jMenu2 = null;
                continue;
            }
            jMenu2.add(jMenuItem);
            if (i + 1 != stringArray.length) continue;
            jMenu2.setText(string3 + " - " + string4);
            keyJMenu.add(jMenu2);
        }
    }

    private JMenuItem createMenuItem(String string) {
        return new KeyJMenuItem(string, AppletConsole.getLabel(string), this.menuMap);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        ((JTextArea)((Object)this.input)).requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doAction(actionEvent.getSource());
    }

    @Override
    protected void execute(String string) {
        super.execute(string);
        if (string == null) {
            ((JTextArea)((Object)this.input)).requestFocus();
        }
    }

    class ControlEnterTextArea
    extends JTextArea
    implements GenericTextArea {
        ControlEnterTextArea() {
        }

        @Override
        public void processComponentKeyEvent(KeyEvent keyEvent) {
            boolean bl;
            int n;
            int n2 = keyEvent.getKeyCode();
            int n3 = AppletConsole.this.processKey(n2, n = keyEvent.getID(), bl = keyEvent.isControlDown());
            if ((n3 & 1) == 1) {
                keyEvent.consume();
            }
            if ((n3 & 2) == 2) {
                if (n2 == 10) {
                    keyEvent.setModifiers(0);
                }
                super.processComponentKeyEvent(keyEvent);
            }
        }
    }

    private class GenericTextPane
    extends JTextPane
    implements GenericTextArea {
        private final Document outputDocument = this.getDocument();

        GenericTextPane() {
        }

        @Override
        public void append(String string) {
            try {
                this.outputDocument.insertString(this.outputDocument.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.setCaretPosition(this.outputDocument.getLength());
        }
    }
}

