/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.NodeCloneable;

public final class BranchProfile
extends NodeCloneable {
    @CompilerDirectives.CompilationFinal
    private boolean visited;

    private BranchProfile() {
    }

    public void enter() {
        if (!this.visited) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.visited = true;
        }
    }

    public boolean isVisited() {
        return this.visited;
    }

    public static BranchProfile create() {
        return new BranchProfile();
    }

    public String toString() {
        return String.format("%s(%s)@%x", this.getClass().getSimpleName(), this.visited ? "visited" : "not-visited", this.hashCode());
    }
}

