/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile.builtin;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import org.jruby.runtime.profile.builtin.Invocation;
import org.jruby.runtime.profile.builtin.InvocationSet;
import org.jruby.runtime.profile.builtin.MethodData;
import org.jruby.runtime.profile.builtin.ProfileData;
import org.jruby.runtime.profile.builtin.ProfilePrinter;
import org.jruby.util.collections.IntHashMap;

public class HtmlProfilePrinter
extends ProfilePrinter {
    private static final long LIMIT = 100000000L;
    String head = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n<html>\n<head>\n  <style media=\"all\" type=\"text/css\">\n    table {\n      border-collapse: collapse;\n      border: 1px solid #CCC;\n      font-family: Verdana, Arial, Helvetica, sans-serif;\n      font-size: 9pt;\n      line-height: normal;\n      width: 100%;\n    }\n\n    th {\n      text-align: center;\n      border-top: 1px solid #FB7A31;\n      border-bottom: 1px solid #FB7A31;\n      background: #FFC;\n      padding: 0.3em;\n      border-left: 1px solid silver;\n    }\n\n    tr.break td {\n      border: 0;\n      border-top: 1px solid #FB7A31;\n      padding: 0;\n      margin: 0;\n    }\n\n    tr.method td {\n      font-weight: bold;\n    }\n\n    td {\n      padding: 0.3em;\n    }\n\n    td:first-child {\n      width: 190px;\n      }\n\n    td {\n      border-left: 1px solid #CCC;\n      text-align: center;\n    }\n\n    .method_name {\n      text-align: left;\n    }\n  </style>\n  </head>\n";

    public HtmlProfilePrinter(ProfileData profileData) {
        super(profileData);
    }

    HtmlProfilePrinter(ProfileData profileData, Invocation topInvocation) {
        super(profileData, topInvocation);
    }

    @Override
    public void printHeader(PrintStream out) {
        out.println(this.head);
        out.println("<body>");
    }

    @Override
    public void printFooter(PrintStream out) {
        out.println("</body>");
        out.println("</html>");
    }

    @Override
    public void printProfile(PrintStream out, boolean first2) {
        Invocation topInvocation = this.getTopInvocation();
        out.printf("<h1>Profile Report: %s</h1>\n", this.getThreadName());
        out.println("<h3>Total time: " + HtmlProfilePrinter.nanoString(topInvocation.getDuration()) + "</h3>");
        out.println("<table>\n  <tr>\n    <th> %Total</th>\n    <th> %Self</th>\n    <th> Total</th>\n    <th> Self</th>\n    <th> Children</th>\n    <th> Calls</th>\n    <th>Name</th>\n  </tr>");
        IntHashMap<MethodData> methods2 = HtmlProfilePrinter.methodData(topInvocation);
        MethodData[] sortedMethods = methods2.values().toArray(new MethodData[methods2.size()]);
        Arrays.sort(sortedMethods, new Comparator<MethodData>(){

            @Override
            public int compare(MethodData md1, MethodData md2) {
                long time2;
                long time1 = md1.totalTime();
                return time1 == (time2 = md2.totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
            }
        });
        for (final MethodData data2 : sortedMethods) {
            Integer[] parentSerials;
            if (this.isProfilerInvocation((Invocation)data2.invocations.get(0))) continue;
            out.println("<tr class='break'><td colspan='7'></td></tr>");
            int serial = data2.serialNumber;
            if (serial != 0 && (parentSerials = this.parentSerials(data2)).length > 0) {
                Integer[] arr$ = parentSerials;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int parentSerial = arr$[i$];
                    this.printInvocationFromParent(out, data2, parentSerial, this.methodName(parentSerial), data2.rootInvocationsFromParent(parentSerial));
                }
            }
            String displayName = this.methodName(serial);
            if (data2.totalTime() >= 100000000L) {
                out.println("<tr class='method'>");
                if (topInvocation.getDuration() == 0L) {
                    out.println("  <td>100%</td>");
                    out.println("  <td>100%</td>");
                } else {
                    out.println("  <td>" + Long.toString(data2.totalTime() * 100L / topInvocation.getDuration()) + "%</td>");
                    out.println("  <td>" + Long.toString(data2.selfTime() * 100L / topInvocation.getDuration()) + "%</td>");
                }
                this.printTimingCells(out, data2);
                out.println("  <td>" + Integer.toString(data2.totalCalls()) + "</td>");
                out.println("  <td>" + this.methodAnchor(displayName) + "</td>");
                out.println("</tr>");
            }
            int[] childSerialsInts = data2.children();
            Integer[] childSerials = new Integer[childSerialsInts.length];
            for (int i2 = 0; i2 < childSerialsInts.length; ++i2) {
                childSerials[i2] = childSerialsInts[i2];
            }
            Arrays.sort(childSerials, new Comparator<Integer>(){

                @Override
                public int compare(Integer child1, Integer child2) {
                    long time2;
                    long time1 = data2.rootInvocationsOfChild(child1).totalTime();
                    return time1 == (time2 = data2.rootInvocationsOfChild(child2).totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
                }
            });
            if (childSerials.length <= 0) continue;
            Integer[] arr$ = childSerials;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int childSerial = arr$[i$];
                if (this.isThisProfilerInvocation(childSerial)) continue;
                String callerName = this.methodName(childSerial);
                InvocationSet invs = data2.rootInvocationsOfChild(childSerial);
                this.printInvocationOfChild(out, methods2, data2, childSerial, callerName, invs);
            }
        }
        out.println("</table>");
    }

    private void printInvocationOfChild(PrintStream out, IntHashMap<MethodData> methods2, MethodData data2, int childSerial, String callerName, InvocationSet invs) {
        out.print("<!-- " + invs.totalTime() + " -->");
        if (invs.totalTime() < 100000000L) {
            return;
        }
        out.println("<tr>");
        out.println("  <td></td>");
        out.println("  <td></td>");
        this.printTimingCells(out, invs);
        out.println("  <td>" + Integer.toString(data2.invocationsOfChild(childSerial).totalCalls()) + "/" + Integer.toString(methods2.get(childSerial).totalCalls()) + "</td>");
        out.println("  <td>" + this.linkToMethod(callerName) + "</td>");
        out.println("</tr>");
    }

    private void printInvocationFromParent(PrintStream out, MethodData data2, int parentSerial, String callerName, InvocationSet invs) {
        if (invs.totalTime() < 100000000L) {
            return;
        }
        out.println("<tr>");
        out.println("  <td></td>");
        out.println("  <td></td>");
        this.printTimingCells(out, invs);
        out.println("  <td>" + Integer.toString(data2.invocationsFromParent(parentSerial).totalCalls()) + "/" + Integer.toString(data2.totalCalls()) + "</td>");
        out.println("  <td>" + this.linkToMethod(callerName) + "</td>");
        out.println("</tr>");
    }

    private String linkToMethod(String callerName) {
        return "<a href='#" + callerName.replaceAll("[><#\\.\\?=:]", "_") + "'>" + callerName + "</a>";
    }

    private String methodAnchor(String callerName) {
        return "<a name='" + callerName.replaceAll("[><#\\.\\?=:]", "_") + "'>" + callerName + "</a>";
    }

    private void printTimingCells(PrintStream out, InvocationSet invs) {
        out.println("  <td>" + HtmlProfilePrinter.nanoString(invs.totalTime()) + "</td>");
        out.println("  <td>" + HtmlProfilePrinter.nanoString(invs.selfTime()) + "</td>");
        out.println("  <td>" + HtmlProfilePrinter.nanoString(invs.childTime()) + "</td>");
    }

    private Integer[] parentSerials(final MethodData data2) {
        int[] parentSerialsInts = data2.parents();
        Integer[] parentSerials = new Integer[parentSerialsInts.length];
        for (int i2 = 0; i2 < parentSerialsInts.length; ++i2) {
            parentSerials[i2] = parentSerialsInts[i2];
        }
        Arrays.sort(parentSerials, new Comparator<Integer>(){

            @Override
            public int compare(Integer parent1, Integer parent2) {
                long time2;
                long time1 = data2.rootInvocationsFromParent(parent1).totalTime();
                return time1 == (time2 = data2.rootInvocationsFromParent(parent2).totalTime()) ? 0 : (time1 < time2 ? -1 : 1);
            }
        });
        return parentSerials;
    }
}

