/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.Collection;
import jcmdline.AbstractHandlerDecorator;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.CmdLineParser;
import jcmdline.DefaultCmdLineHandler;
import jcmdline.Parameter;
import jcmdline.StringFormatHelper;
import jcmdline.Strings;

public class HelpCmdLineHandler
extends AbstractHandlerDecorator {
    private BooleanParam helpOpt;
    private BooleanParam licenseOpt;
    private BooleanParam hiddenHelpOpt;
    private String help;
    private String license;
    private String hiddenHelp;

    public HelpCmdLineHandler(String help, String license, String hiddenHelp, CmdLineHandler handler) {
        super(handler);
        if (help == null || help.length() == 0) {
            throw new IllegalArgumentException(Strings.get("HelpCmdLineHandler.helpEmptyError"));
        }
        this.help = help;
        this.license = license == null || license.length() == 0 ? Strings.get("HelpCmdLineHandler.license.nolicense") : license;
        this.hiddenHelp = hiddenHelp == null || hiddenHelp.length() == 0 ? null : hiddenHelp;
        this.helpOpt = new BooleanParam(Strings.get("HelpCmdLineHandler.help.tag"), Strings.get("HelpCmdLineHandler.help.desc"));
        this.helpOpt.setIgnoreRequired(true);
        this.licenseOpt = new BooleanParam(Strings.get("HelpCmdLineHandler.license.tag"), Strings.get("HelpCmdLineHandler.license.desc"));
        this.licenseOpt.setIgnoreRequired(true);
        this.hiddenHelpOpt = new BooleanParam(Strings.get("HelpCmdLineHandler.helpHidden.tag"), Strings.get("HelpCmdLineHandler.helpHidden.desc"), true);
        this.hiddenHelpOpt.setIgnoreRequired(true);
        this.setCustomOptions(new Parameter[]{this.helpOpt, this.hiddenHelpOpt, this.licenseOpt});
    }

    public HelpCmdLineHandler(String help, CmdLineHandler handler) {
        this(help, null, null, handler);
    }

    public HelpCmdLineHandler(String help, String license, CmdLineHandler handler) {
        this(help, license, null, handler);
    }

    public HelpCmdLineHandler(String help, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this(help, null, null, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args, parser));
    }

    public HelpCmdLineHandler(String help, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(help, null, null, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String cmdName, String cmdDesc, Collection options, Collection args) {
        this(help, null, null, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String hiddenHelp, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this(help, null, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args, parser));
    }

    public HelpCmdLineHandler(String help, String license, String hiddenHelp, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this(help, license, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args, parser));
    }

    public HelpCmdLineHandler(String help, String hiddenHelp, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(help, null, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String license, String hiddenHelp, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(help, license, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String hiddenHelp, String cmdName, String cmdDesc, Collection options, Collection args) {
        this(help, null, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String license, String hiddenHelp, String cmdName, String cmdDesc, Collection options, Collection args) {
        this(help, license, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    protected boolean processParsedOptions(boolean parseOk) {
        if (this.helpOpt.isTrue() || this.hiddenHelpOpt.isTrue() || this.licenseOpt.isTrue()) {
            if (this.helpOpt.isTrue() || this.hiddenHelpOpt.isTrue()) {
                System.out.println(this.getUsage(this.hiddenHelpOpt.isTrue()));
                int lineLen = this.getParser().getUsageFormatter().getLineLength();
                StringFormatHelper sHelper = StringFormatHelper.getHelper();
                System.out.println("\n" + sHelper.formatBlockedText(this.help, 0, lineLen));
                if (this.hiddenHelpOpt.isTrue() && this.hiddenHelp != null) {
                    System.out.println("\n" + sHelper.formatBlockedText(this.hiddenHelp, 0, lineLen));
                }
            } else if (this.licenseOpt.isTrue() && this.license != null) {
                int lineLen = this.getParser().getUsageFormatter().getLineLength();
                StringFormatHelper sHelper = StringFormatHelper.getHelper();
                System.out.println("\n" + sHelper.formatBlockedText(this.license, 0, lineLen));
            }
            System.exit(0);
        }
        return parseOk;
    }
}

