/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDFunction;

public class PDInterpolationFunction
extends PDFunction {
    public static final COSName DK_C0 = COSName.constant("C0");
    public static final COSName DK_C1 = COSName.constant("C1");
    public static final COSName DK_N = COSName.constant("N");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private float[] c0;
    private float[] c1;
    private float n;

    protected PDInterpolationFunction(COSObject cOSObject) {
        super(cOSObject);
        int n;
        COSArray cOSArray = this.cosGetDict().get(DK_C0).asArray();
        if (cOSArray == null) {
            this.c0 = new float[]{0.0f};
        } else {
            this.c0 = new float[cOSArray.size()];
            n = 0;
            while (n < this.c0.length) {
                this.c0[n] = cOSArray.get(n).asNumber().floatValue();
                ++n;
            }
        }
        COSArray cOSArray2 = this.cosGetDict().get(DK_C1).asArray();
        if (cOSArray2 == null) {
            this.c1 = new float[]{1.0f};
        } else {
            this.c1 = new float[cOSArray2.size()];
            n = 0;
            while (n < this.c1.length) {
                this.c1[n] = cOSArray2.get(n).asNumber().floatValue();
                ++n;
            }
        }
        this.n = this.cosGetDict().get(DK_N).asNumber().floatValue();
    }

    protected float[] evaluate(float f) {
        if ((double)f == 0.0) {
            return this.getC0();
        }
        if ((double)f == 1.0) {
            return this.getC1();
        }
        float[] fArray = new float[this.getOutputSize()];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = (float)((double)this.c0[n] + Math.pow(f, this.n) * (double)(this.c1[n] - this.c0[n]));
            ++n;
        }
        return fArray;
    }

    @Override
    public float[] evaluate(float[] fArray) {
        int n = this.getOutputSize();
        float[] fArray2 = new float[fArray.length * n];
        int n2 = 0;
        while (n2 < fArray.length) {
            System.arraycopy(this.evaluate(fArray[n2]), n2, fArray2, n2 * n, n);
            ++n2;
        }
        return fArray2;
    }

    public float[] getC0() {
        return this.c0;
    }

    public float[] getC1() {
        return this.c1;
    }

    public float getN() {
        return this.n;
    }

    @Override
    public int getOutputSize() {
        return this.getC0().length;
    }

    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDInterpolationFunction(cOSObject);
        }
    }
}

