/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.MultipleGradientPaint;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.RadialGradientPaint;
import org.icepdf.core.util.Library;

public class ShadingType3Pattern
extends ShadingPattern {
    private static final Logger logger = Logger.getLogger(ShadingType3Pattern.class.toString());
    protected Function[] function;
    protected Vector<Number> domain;
    protected Vector coords;
    protected Vector<Boolean> extend;
    protected RadialGradientPaint radialGradientPaint;

    public ShadingType3Pattern(Library library, Hashtable entries) {
        super(library, entries);
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        if (this.shading == null) {
            this.shading = this.library.getDictionary(this.entries, "Shading");
        }
        this.shadingType = this.library.getInt(this.shading, "ShadingType");
        this.bBox = this.library.getRectangle(this.shading, "BBox");
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shading, "ColorSpace"));
        if (this.library.getObject(this.shading, "Background") != null && this.library.getObject(this.shading, "Background") instanceof Vector) {
            this.background = (Vector)this.library.getObject(this.shading, "Background");
        }
        this.antiAlias = this.library.getBoolean(this.shading, "AntiAlias");
        if (this.library.getObject(this.shading, "Domain") instanceof Vector) {
            this.domain = (Vector)this.library.getObject(this.shading, "Domain");
        } else {
            this.domain = new Vector(2);
            this.domain.add(new Float(0.0));
            this.domain.add(new Float(1.0));
        }
        if (this.library.getObject(this.shading, "Coords") instanceof Vector) {
            this.coords = (Vector)this.library.getObject(this.shading, "Coords");
        }
        if (this.library.getObject(this.shading, "Extend") instanceof Vector) {
            this.extend = (Vector)this.library.getObject(this.shading, "Extend");
        } else {
            this.extend = new Vector(2);
            this.extend.add(false);
            this.extend.add(false);
        }
        Object tmp = this.library.getObject(this.shading, "Function");
        if (tmp != null) {
            if (!(tmp instanceof Vector)) {
                this.function = new Function[]{Function.getFunction(this.library, tmp)};
            } else {
                Vector functionTemp = (Vector)tmp;
                this.function = new Function[functionTemp.size()];
                for (int i = 0; i < functionTemp.size(); ++i) {
                    this.function[i] = Function.getFunction(this.library, functionTemp.get(i));
                }
            }
        }
        float t0 = this.domain.get(0).floatValue();
        float t1 = this.domain.get(1).floatValue();
        float[] s = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f};
        Point2D.Float center = new Point2D.Float(((Number)this.coords.get(0)).floatValue(), ((Number)this.coords.get(1)).floatValue());
        Point2D.Float focus = new Point2D.Float(((Number)this.coords.get(3)).floatValue(), ((Number)this.coords.get(4)).floatValue());
        float radius = ((Number)this.coords.get(2)).floatValue();
        float radius2 = ((Number)this.coords.get(5)).floatValue();
        if (radius2 > radius) {
            radius = radius2;
        }
        Color color1 = this.calculateColour(this.colorSpace, s[0], t0, t1);
        Color color2 = this.calculateColour(this.colorSpace, s[1], t0, t1);
        Color color3 = this.calculateColour(this.colorSpace, s[2], t0, t1);
        Color color4 = this.calculateColour(this.colorSpace, s[3], t0, t1);
        Color color5 = this.calculateColour(this.colorSpace, s[4], t0, t1);
        if (color1 == null || color2 == null) {
            return;
        }
        Color[] colors = new Color[]{color1, color2, color3, color4, color5};
        this.radialGradientPaint = new RadialGradientPaint(center, radius, focus, s, colors, MultipleGradientPaint.NO_CYCLE, MultipleGradientPaint.LINEAR_RGB, this.matrix);
        this.inited = true;
    }

    private Color calculateColour(PColorSpace colorSpace, float s, float t0, float t1) {
        float t = this.parametrixValue(s, t0, t1, this.extend);
        float[] input = new float[]{t};
        if (this.function != null) {
            float[] output;
            int length = this.function.length;
            if (length == 1) {
                output = this.function[0].calculate(input);
            } else {
                output = new float[length];
                for (int i = 0; i < length; ++i) {
                    output[i] = this.function[i].calculate(input)[0];
                }
            }
            if (output != null) {
                if (!(colorSpace instanceof DeviceN)) {
                    output = PColorSpace.reverse(output);
                }
                return colorSpace.getColor(output);
            }
            return null;
        }
        logger.fine("Error processing Shading Type 3 Pattern.");
        return null;
    }

    private float parametrixValue(float linearMapping, float t0, float t1, Vector extended) {
        return t0 + (t1 - t0) * linearMapping;
    }

    public Paint getPaint() {
        this.init();
        return this.radialGradientPaint;
    }

    public String toSting() {
        return super.toString() + "\n                    domain: " + this.domain + "\n                    coords: " + this.coords + "\n                    extend: " + this.extend + "\n                 function: " + this.function;
    }
}

