/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.CallbackProxy;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import de.intarsys.nativec.api.CLong;
import de.intarsys.nativec.api.CWideString;
import de.intarsys.nativec.api.ICallback;
import de.intarsys.nativec.api.INativeCallback;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;

public abstract class JnaNativeCallback
implements INativeCallback,
CallbackProxy {
    private ICallback callback;

    public static Class<?> translateType(Class<?> clazz) {
        if (CWideString.class.isAssignableFrom(clazz)) {
            return WString.class;
        }
        if (CLong.class.isAssignableFrom(clazz)) {
            return NativeLong.class;
        }
        if (NativeObject.class.isAssignableFrom(clazz)) {
            return Pointer.class;
        }
        if (INativeHandle.class.isAssignableFrom(clazz)) {
            return Pointer.class;
        }
        return clazz;
    }

    public JnaNativeCallback(ICallback iCallback) {
        this.callback = iCallback;
    }

    public Object callback(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            WString wString;
            Class<?> clazz = this.callback.getParameterTypes()[n];
            if (CWideString.class.isAssignableFrom(clazz)) {
                wString = (WString)objectArray[n];
                object = new CWideString(wString.toString());
            } else if (CLong.class.isAssignableFrom(clazz)) {
                wString = (NativeLong)objectArray[n];
                object = new CLong(wString.longValue());
            } else if (NativeObject.class.isAssignableFrom(clazz)) {
                wString = (Pointer)objectArray[n];
                if (wString == null) {
                    object = null;
                } else {
                    JnaNativeHandle jnaNativeHandle = new JnaNativeHandle((Pointer)wString);
                    INativeType iNativeType = NativeType.lookup(clazz);
                    if (iNativeType == null) {
                        throw new IllegalArgumentException("no type for '" + clazz + "'");
                    }
                    object = iNativeType.createNative(jnaNativeHandle);
                }
            } else {
                object = INativeHandle.class.isAssignableFrom(clazz) ? ((wString = (Pointer)objectArray[n]) == null ? null : new JnaNativeHandle((Pointer)wString)) : objectArray[n];
            }
            objectArray[n] = object;
            ++n;
        }
        return this.callback.invoke(objectArray);
    }

    public Class<?>[] getParameterTypes() {
        Class<?>[] classArray = this.callback.getParameterTypes();
        Class[] classArray2 = new Class[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            classArray2[n] = JnaNativeCallback.translateType(classArray[n]);
            ++n;
        }
        return classArray2;
    }

    public Class<?> getReturnType() {
        return JnaNativeCallback.translateType(this.callback.getReturnType());
    }
}

