/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.pdfsam.guiclient.commons.components.JPdfSelectionTable;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class MoveUpSelectionTableAction
extends AbstractAction {
    private static final long serialVersionUID = 4713230401801850598L;
    private JPdfSelectionTable mainTable;

    public MoveUpSelectionTableAction(JPdfSelectionTable mainTable) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Move Up"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Move up selected pdf file"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/up.png")));
        this.mainTable = mainTable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] selectedRows = this.mainTable.getSelectedRows();
        if (selectedRows.length > 0) {
            ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).moveUpRows(selectedRows);
            if (selectedRows[0] > 0) {
                this.mainTable.setRowSelectionInterval(selectedRows[0] - 1, selectedRows[selectedRows.length - 1] - 1);
            }
        }
    }
}

