/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.List;

public final class BasicCompositeMonitor
extends AbstractMonitor<Integer>
implements CompositeMonitor<Integer> {
    private final List<Monitor<?>> monitors;

    public BasicCompositeMonitor(MonitorConfig config, List<Monitor<?>> monitors) {
        super(config);
        this.monitors = ImmutableList.copyOf(monitors);
    }

    @Override
    public Integer getValue(int pollerIdx) {
        return this.monitors.size();
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicCompositeMonitor)) {
            return false;
        }
        BasicCompositeMonitor m = (BasicCompositeMonitor)obj;
        return this.config.equals(m.getConfig()) && ((Object)this.monitors).equals(m.getMonitors());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.monitors});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("monitors", this.monitors).toString();
    }
}

