/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jul;

import java.util.logging.Logger;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.julbridge.JULLevelConverter;
import org.apache.logging.julbridge.JULLog4jEventConverter;

public class JULAppender
extends AppenderSkeleton {
    private JULLevelConverter levelConverter = JULLog4jEventConverter.DEFAULT_LEVEL_CONVERTER;
    private String customLevelConverterClass = null;

    public JULAppender() {
    }

    public JULAppender(Layout layout) {
        this.setLayout(layout);
    }

    public void activateOptions() {
        if (this.customLevelConverterClass != null) {
            try {
                Class<?> clazz = Class.forName(this.customLevelConverterClass);
                this.levelConverter = (JULLevelConverter)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create custom Level Converter class '" + this.customLevelConverterClass + "'", e);
            }
        }
        super.activateOptions();
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }

    protected void append(LoggingEvent loggingEvent) {
        Logger logger = Logger.getLogger(loggingEvent.getLoggerName());
        if (logger == null) {
            LogLog.warn((String)("Cannot obtain JUL " + loggingEvent.getLoggerName() + ". " + "Verify that this appender is used while an appropriate LogManager " + "is active."));
            return;
        }
        String msg = this.layout != null ? this.layout.format(loggingEvent) : loggingEvent.getRenderedMessage();
        Level level = loggingEvent.getLevel();
        java.util.logging.Level jullevel = this.levelConverter.convertLog4jLevel(level);
        logger.log(jullevel, msg);
    }

    public final String getCustomLevelConverterClass() {
        return this.customLevelConverterClass;
    }

    public final void setCustomLevelConverterClass(String customLevelConverterClass) {
        this.customLevelConverterClass = customLevelConverterClass;
    }
}

