/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.WebXml;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JspConfig {
    private final Log log = LogFactory.getLog(JspConfig.class);
    private Vector<JspPropertyGroup> jspProperties = null;
    private ServletContext ctxt;
    private volatile boolean initialized = false;
    private static final String defaultIsXml = null;
    private String defaultIsELIgnored = null;
    private static final String defaultIsScriptingInvalid = null;
    private String defaultDeferedSyntaxAllowedAsLiteral = null;
    private static final String defaultTrimDirectiveWhitespaces = null;
    private static final String defaultDefaultContentType = null;
    private static final String defaultBuffer = null;
    private static final String defaultErrorOnUndeclaredNamespace = "false";
    private JspProperty defaultJspProperty;

    public JspConfig(ServletContext ctxt) {
        this.ctxt = ctxt;
    }

    private double getVersion(TreeNode webApp) {
        String v = webApp.findAttribute("version");
        if (v != null) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2.3;
    }

    private void processWebDotXml() throws JasperException {
        WebXml webXml = null;
        try {
            TreeNode jspConfig;
            webXml = new WebXml(this.ctxt);
            boolean validate = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
            String blockExternalString = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
            boolean blockExternal = blockExternalString == null ? Constants.IS_SECURITY_ENABLED : Boolean.parseBoolean(blockExternalString);
            TreeNode webApp = null;
            if (webXml.getInputSource() != null) {
                ParserUtils pu = new ParserUtils(validate, blockExternal);
                webApp = pu.parseXMLDocument(webXml.getSystemId(), webXml.getInputSource());
            }
            if (webApp == null || this.getVersion(webApp) < 2.4) {
                this.defaultIsELIgnored = "true";
                this.defaultDeferedSyntaxAllowedAsLiteral = "true";
                return;
            }
            if (this.getVersion(webApp) < 2.5) {
                this.defaultDeferedSyntaxAllowedAsLiteral = "true";
            }
            if ((jspConfig = webApp.findChild("jsp-config")) == null) {
                return;
            }
            this.jspProperties = new Vector();
            Iterator<TreeNode> jspPropertyList = jspConfig.findChildren("jsp-property-group");
            while (jspPropertyList.hasNext()) {
                TreeNode element = jspPropertyList.next();
                Iterator<TreeNode> list = element.findChildren();
                Vector<String> urlPatterns = new Vector<String>();
                String pageEncoding = null;
                String scriptingInvalid = null;
                String elIgnored = null;
                String isXml = null;
                Vector<String> includePrelude = new Vector<String>();
                Vector<String> includeCoda = new Vector<String>();
                String deferredSyntaxAllowedAsLiteral = null;
                String trimDirectiveWhitespaces = null;
                String defaultContentType = null;
                String buffer = null;
                String errorOnUndeclaredNamespace = null;
                while (list.hasNext()) {
                    element = list.next();
                    String tname = element.getName();
                    if ("url-pattern".equals(tname)) {
                        urlPatterns.addElement(element.getBody());
                        continue;
                    }
                    if ("page-encoding".equals(tname)) {
                        pageEncoding = element.getBody();
                        continue;
                    }
                    if ("is-xml".equals(tname)) {
                        isXml = element.getBody();
                        continue;
                    }
                    if ("el-ignored".equals(tname)) {
                        elIgnored = element.getBody();
                        continue;
                    }
                    if ("scripting-invalid".equals(tname)) {
                        scriptingInvalid = element.getBody();
                        continue;
                    }
                    if ("include-prelude".equals(tname)) {
                        includePrelude.addElement(element.getBody());
                        continue;
                    }
                    if ("include-coda".equals(tname)) {
                        includeCoda.addElement(element.getBody());
                        continue;
                    }
                    if ("deferred-syntax-allowed-as-literal".equals(tname)) {
                        deferredSyntaxAllowedAsLiteral = element.getBody();
                        continue;
                    }
                    if ("trim-directive-whitespaces".equals(tname)) {
                        trimDirectiveWhitespaces = element.getBody();
                        continue;
                    }
                    if ("default-content-type".equals(tname)) {
                        defaultContentType = element.getBody();
                        continue;
                    }
                    if ("buffer".equals(tname)) {
                        buffer = element.getBody();
                        continue;
                    }
                    if (!"error-on-undeclared-namespace".equals(tname)) continue;
                    errorOnUndeclaredNamespace = element.getBody();
                }
                if (urlPatterns.size() == 0) continue;
                for (int p = 0; p < urlPatterns.size(); ++p) {
                    String urlPattern = (String)urlPatterns.elementAt(p);
                    String path = null;
                    String extension = null;
                    if (urlPattern.indexOf(42) < 0) {
                        path = urlPattern;
                    } else {
                        String file;
                        int i = urlPattern.lastIndexOf(47);
                        if (i >= 0) {
                            path = urlPattern.substring(0, i + 1);
                            file = urlPattern.substring(i + 1);
                        } else {
                            file = urlPattern;
                        }
                        if (file.equals("*")) {
                            extension = "*";
                        } else if (file.startsWith("*.")) {
                            extension = file.substring(file.indexOf(46) + 1);
                        }
                        boolean isStar = "*".equals(extension);
                        if (path == null && (extension == null || isStar) || path != null && !isStar) {
                            if (!this.log.isWarnEnabled()) continue;
                            this.log.warn((Object)Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", urlPattern));
                            continue;
                        }
                    }
                    JspProperty property = new JspProperty(isXml, elIgnored, scriptingInvalid, pageEncoding, includePrelude, includeCoda, deferredSyntaxAllowedAsLiteral, trimDirectiveWhitespaces, defaultContentType, buffer, errorOnUndeclaredNamespace);
                    JspPropertyGroup propertyGroup = new JspPropertyGroup(path, extension, property);
                    this.jspProperties.addElement(propertyGroup);
                }
            }
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
        finally {
            if (webXml != null) {
                webXml.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws JasperException {
        if (!this.initialized) {
            JspConfig jspConfig = this;
            synchronized (jspConfig) {
                if (!this.initialized) {
                    this.processWebDotXml();
                    this.defaultJspProperty = new JspProperty(defaultIsXml, this.defaultIsELIgnored, defaultIsScriptingInvalid, null, null, null, this.defaultDeferedSyntaxAllowedAsLiteral, defaultTrimDirectiveWhitespaces, defaultDefaultContentType, defaultBuffer, defaultErrorOnUndeclaredNamespace);
                    this.initialized = true;
                }
            }
        }
    }

    private JspPropertyGroup selectProperty(JspPropertyGroup prev, JspPropertyGroup curr) {
        if (prev == null) {
            return curr;
        }
        if (prev.getExtension() == null) {
            return prev;
        }
        if (curr.getExtension() == null) {
            return curr;
        }
        String prevPath = prev.getPath();
        String currPath = curr.getPath();
        if (prevPath == null && currPath == null) {
            return prev;
        }
        if (prevPath == null && currPath != null) {
            return curr;
        }
        if (prevPath != null && currPath == null) {
            return prev;
        }
        if (prevPath.length() >= currPath.length()) {
            return prev;
        }
        return curr;
    }

    public JspProperty findJspProperty(String uri) throws JasperException {
        this.init();
        if (this.jspProperties == null || uri.endsWith(".tag") || uri.endsWith(".tagx")) {
            return this.defaultJspProperty;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        Vector<String> includePreludes = new Vector<String>();
        Vector<String> includeCodas = new Vector<String>();
        JspPropertyGroup isXmlMatch = null;
        JspPropertyGroup elIgnoredMatch = null;
        JspPropertyGroup scriptingInvalidMatch = null;
        JspPropertyGroup pageEncodingMatch = null;
        JspPropertyGroup deferedSyntaxAllowedAsLiteralMatch = null;
        JspPropertyGroup trimDirectiveWhitespacesMatch = null;
        JspPropertyGroup defaultContentTypeMatch = null;
        JspPropertyGroup bufferMatch = null;
        JspPropertyGroup errorOnUndeclaredNamespaceMatch = null;
        for (JspPropertyGroup jpg : this.jspProperties) {
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (extension != null ? path != null && uriPath != null && !uriPath.startsWith(path) || !extension.equals("*") && !extension.equals(uriExtension) : !uri.equals(path)) continue;
            if (jp.getIncludePrelude() != null) {
                includePreludes.addAll(jp.getIncludePrelude());
            }
            if (jp.getIncludeCoda() != null) {
                includeCodas.addAll(jp.getIncludeCoda());
            }
            if (jp.isXml() != null) {
                isXmlMatch = this.selectProperty(isXmlMatch, jpg);
            }
            if (jp.isELIgnored() != null) {
                elIgnoredMatch = this.selectProperty(elIgnoredMatch, jpg);
            }
            if (jp.isScriptingInvalid() != null) {
                scriptingInvalidMatch = this.selectProperty(scriptingInvalidMatch, jpg);
            }
            if (jp.getPageEncoding() != null) {
                pageEncodingMatch = this.selectProperty(pageEncodingMatch, jpg);
            }
            if (jp.isDeferedSyntaxAllowedAsLiteral() != null) {
                deferedSyntaxAllowedAsLiteralMatch = this.selectProperty(deferedSyntaxAllowedAsLiteralMatch, jpg);
            }
            if (jp.isTrimDirectiveWhitespaces() != null) {
                trimDirectiveWhitespacesMatch = this.selectProperty(trimDirectiveWhitespacesMatch, jpg);
            }
            if (jp.getDefaultContentType() != null) {
                defaultContentTypeMatch = this.selectProperty(defaultContentTypeMatch, jpg);
            }
            if (jp.getBuffer() != null) {
                bufferMatch = this.selectProperty(bufferMatch, jpg);
            }
            if (jp.isErrorOnUndeclaredNamespace() == null) continue;
            errorOnUndeclaredNamespaceMatch = this.selectProperty(errorOnUndeclaredNamespaceMatch, jpg);
        }
        String isXml = defaultIsXml;
        String isELIgnored = this.defaultIsELIgnored;
        String isScriptingInvalid = defaultIsScriptingInvalid;
        String pageEncoding = null;
        String isDeferedSyntaxAllowedAsLiteral = this.defaultDeferedSyntaxAllowedAsLiteral;
        String isTrimDirectiveWhitespaces = defaultTrimDirectiveWhitespaces;
        String defaultContentType = defaultDefaultContentType;
        String buffer = defaultBuffer;
        String errorOnUndelcaredNamespace = defaultErrorOnUndeclaredNamespace;
        if (isXmlMatch != null) {
            isXml = isXmlMatch.getJspProperty().isXml();
        }
        if (elIgnoredMatch != null) {
            isELIgnored = elIgnoredMatch.getJspProperty().isELIgnored();
        }
        if (scriptingInvalidMatch != null) {
            isScriptingInvalid = scriptingInvalidMatch.getJspProperty().isScriptingInvalid();
        }
        if (pageEncodingMatch != null) {
            pageEncoding = pageEncodingMatch.getJspProperty().getPageEncoding();
        }
        if (deferedSyntaxAllowedAsLiteralMatch != null) {
            isDeferedSyntaxAllowedAsLiteral = deferedSyntaxAllowedAsLiteralMatch.getJspProperty().isDeferedSyntaxAllowedAsLiteral();
        }
        if (trimDirectiveWhitespacesMatch != null) {
            isTrimDirectiveWhitespaces = trimDirectiveWhitespacesMatch.getJspProperty().isTrimDirectiveWhitespaces();
        }
        if (defaultContentTypeMatch != null) {
            defaultContentType = defaultContentTypeMatch.getJspProperty().getDefaultContentType();
        }
        if (bufferMatch != null) {
            buffer = bufferMatch.getJspProperty().getBuffer();
        }
        if (errorOnUndeclaredNamespaceMatch != null) {
            errorOnUndelcaredNamespace = errorOnUndeclaredNamespaceMatch.getJspProperty().isErrorOnUndeclaredNamespace();
        }
        return new JspProperty(isXml, isELIgnored, isScriptingInvalid, pageEncoding, includePreludes, includeCodas, isDeferedSyntaxAllowedAsLiteral, isTrimDirectiveWhitespaces, defaultContentType, buffer, errorOnUndelcaredNamespace);
    }

    public boolean isJspPage(String uri) throws JasperException {
        this.init();
        if (this.jspProperties == null) {
            return false;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        for (JspPropertyGroup jpg : this.jspProperties) {
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (!(extension == null ? uri.equals(path) : !(path != null && !path.equals(uriPath) || !extension.equals("*") && !extension.equals(uriExtension)))) continue;
            return true;
        }
        return false;
    }

    public static class JspProperty {
        private String isXml;
        private String elIgnored;
        private String scriptingInvalid;
        private String pageEncoding;
        private Vector<String> includePrelude;
        private Vector<String> includeCoda;
        private String deferedSyntaxAllowedAsLiteral;
        private String trimDirectiveWhitespaces;
        private String defaultContentType;
        private String buffer;
        private String errorOnUndeclaredNamespace;

        public JspProperty(String isXml, String elIgnored, String scriptingInvalid, String pageEncoding, Vector<String> includePrelude, Vector<String> includeCoda, String deferedSyntaxAllowedAsLiteral, String trimDirectiveWhitespaces, String defaultContentType, String buffer, String errorOnUndeclaredNamespace) {
            this.isXml = isXml;
            this.elIgnored = elIgnored;
            this.scriptingInvalid = scriptingInvalid;
            this.pageEncoding = pageEncoding;
            this.includePrelude = includePrelude;
            this.includeCoda = includeCoda;
            this.deferedSyntaxAllowedAsLiteral = deferedSyntaxAllowedAsLiteral;
            this.trimDirectiveWhitespaces = trimDirectiveWhitespaces;
            this.defaultContentType = defaultContentType;
            this.buffer = buffer;
            this.errorOnUndeclaredNamespace = errorOnUndeclaredNamespace;
        }

        public String isXml() {
            return this.isXml;
        }

        public String isELIgnored() {
            return this.elIgnored;
        }

        public String isScriptingInvalid() {
            return this.scriptingInvalid;
        }

        public String getPageEncoding() {
            return this.pageEncoding;
        }

        public Vector<String> getIncludePrelude() {
            return this.includePrelude;
        }

        public Vector<String> getIncludeCoda() {
            return this.includeCoda;
        }

        public String isDeferedSyntaxAllowedAsLiteral() {
            return this.deferedSyntaxAllowedAsLiteral;
        }

        public String isTrimDirectiveWhitespaces() {
            return this.trimDirectiveWhitespaces;
        }

        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        public String getBuffer() {
            return this.buffer;
        }

        public String isErrorOnUndeclaredNamespace() {
            return this.errorOnUndeclaredNamespace;
        }
    }

    public static class JspPropertyGroup {
        private String path;
        private String extension;
        private JspProperty jspProperty;

        JspPropertyGroup(String path, String extension, JspProperty jspProperty) {
            this.path = path;
            this.extension = extension;
            this.jspProperty = jspProperty;
        }

        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public JspProperty getJspProperty() {
            return this.jspProperty;
        }
    }
}

