/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.util.HashSet;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlErrorHandler
implements ErrorHandler {
    private static final StringManager sm = StringManager.getManager(Constants.PACKAGE_NAME);
    private final Set<SAXParseException> errors = new HashSet<SAXParseException>();
    private final Set<SAXParseException> warnings = new HashSet<SAXParseException>();

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errors.add(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.warnings.add(exception);
    }

    public Set<SAXParseException> getErrors() {
        return this.errors;
    }

    public Set<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public void logFindings(Log log, String source) {
        for (SAXParseException e : this.getWarnings()) {
            log.warn((Object)sm.getString("xmlErrorHandler.warning", e.getMessage(), source));
        }
        for (SAXParseException e : this.getErrors()) {
            log.warn((Object)sm.getString("xmlErrorHandler.error", e.getMessage(), source));
        }
    }
}

