define([
    'jquery',
    'msg/Msg',
    //non-exporting
    'foundation'
], function ($, Msg) {
    'use strict';
    $(function () {
        $(document).foundation();

        var $loginForm = $('#LoginForm'),
            $errorMessage = $('.error-message');

        var uri = window.location.pathname,
            sso_token = window.location.pathname.split('/')[2];

        // hotspot login
        var $LoginDescription = $('#HotspotLogin').find('#LoginDescription'),
            $ErrorMessage     = $('#HotspotLogin').find('.error-message');

        $.ajax({
            url: '/api/login',
            type: 'POST',
            data: JSON.stringify({
                for_sso: true,
                sso_token: sso_token
            }),
            success: function(data, textStatus, xhr) {
                $errorMessage.hide();

                $.get('/api/self', {}, function(data) {
                    window.location.href='/manage' + (data.last_site_name ? '/s/'+data.last_site_name : '');
                });
            },
            error: function(xhr, textStatus, errorThrown) {
                var response = $.parseJSON(xhr.responseText),
                    error_msg;

                if(response.meta && response.meta.msg) {
                    error_msg = response.meta.msg;
                    
                    if(error_msg === 'api.err.BetaQuotaReached') {
                        error_msg = Msg.E_BetaQuotaReached;
                    }

                    $errorMessage.text(error_msg);
                    $errorMessage.show();
                }
            }
        });
    });
});
