/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.carrotsearch.hppc.ByteArrayList;
import morfologik.tools.SequenceEncoders;

final class SequenceAssembler {
    private final byte annotationSeparator;
    private final ByteArrayList src = new ByteArrayList();
    private final ByteArrayList dst = new ByteArrayList();
    private final ByteArrayList tmp = new ByteArrayList();
    private final SequenceEncoders.IEncoder encoder;

    public SequenceAssembler(SequenceEncoders.IEncoder encoder) {
        this(encoder, 43);
    }

    public SequenceAssembler(SequenceEncoders.IEncoder encoder, byte annotationSeparator) {
        this.annotationSeparator = annotationSeparator;
        this.encoder = encoder;
    }

    byte[] encode(byte[] wordForm, byte[] wordLemma, byte[] wordTag) {
        this.src.clear();
        this.dst.clear();
        this.tmp.clear();
        this.tmp.add(wordForm);
        this.tmp.add(this.annotationSeparator);
        this.src.add(wordForm);
        this.dst.add(wordLemma);
        this.encoder.encode(this.src, this.dst, this.tmp);
        this.tmp.add(this.annotationSeparator);
        if (wordTag != null) {
            this.tmp.add(wordTag);
        }
        return this.tmp.toArray();
    }
}

