/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.Event;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.Span;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

public class NameFinderEventStream
extends AbstractEventStream<NameSample> {
    private NameContextGenerator contextGenerator;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private String type;
    private SequenceCodec<String> codec;

    public NameFinderEventStream(ObjectStream<NameSample> dataStream, String type, NameContextGenerator contextGenerator, SequenceCodec codec) {
        super(dataStream);
        this.codec = codec;
        if (codec == null) {
            this.codec = new BioCodec();
        }
        this.contextGenerator = contextGenerator;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        this.type = type != null ? type : "default";
    }

    public NameFinderEventStream(ObjectStream<NameSample> dataStream) {
        this(dataStream, null, new DefaultNameContextGenerator(), null);
    }

    @Deprecated
    public static String[] generateOutcomes(Span[] names, String type, int length) {
        String[] outcomes = new String[length];
        for (int i = 0; i < outcomes.length; ++i) {
            outcomes[i] = "other";
        }
        for (Span name : names) {
            outcomes[name.getStart()] = name.getType() == null ? type + "-" + "start" : name.getType() + "-" + "start";
            for (int i = name.getStart() + 1; i < name.getEnd(); ++i) {
                outcomes[i] = name.getType() == null ? type + "-" + "cont" : name.getType() + "-" + "cont";
            }
        }
        return outcomes;
    }

    public static List<Event> generateEvents(String[] sentence, String[] outcomes, NameContextGenerator cg) {
        ArrayList<Event> events = new ArrayList<Event>(outcomes.length);
        for (int i = 0; i < outcomes.length; ++i) {
            events.add(new Event(outcomes[i], cg.getContext(i, sentence, outcomes, null)));
        }
        cg.updateAdaptiveData(sentence, outcomes);
        return events;
    }

    @Override
    protected Iterator<Event> createEvents(NameSample sample) {
        if (sample.isClearAdaptiveDataSet()) {
            this.contextGenerator.clearAdaptiveData();
        }
        String[] outcomes = this.codec.encode(sample.getNames(), sample.getSentence().length);
        this.additionalContextFeatureGenerator.setCurrentContext(sample.getAdditionalContext());
        String[] tokens = new String[sample.getSentence().length];
        for (int i = 0; i < sample.getSentence().length; ++i) {
            tokens[i] = sample.getSentence()[i];
        }
        return NameFinderEventStream.generateEvents(tokens, outcomes, this.contextGenerator).iterator();
    }

    public static String[][] additionalContext(String[] tokens, Map<String, String> prevMap) {
        String[][] ac = new String[tokens.length][1];
        for (int ti = 0; ti < tokens.length; ++ti) {
            String pt = prevMap.get(tokens[ti]);
            ac[ti][0] = "pd=" + pt;
        }
        return ac;
    }
}

