/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tools.StringTools;

public class ManualTagger
implements WordTagger {
    private final Map<String, List<TaggedWord>> mapping;

    public ManualTagger(InputStream inputStream) throws IOException {
        this.mapping = this.loadMapping(inputStream, "utf8");
    }

    private Map<String, List<TaggedWord>> loadMapping(InputStream inputStream, String encoding) throws IOException {
        HashMap<String, List<TaggedWord>> map = new HashMap<String, List<TaggedWord>>();
        try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                String[] parts = line.split("\t");
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual tagger dictionary, expected three tab-separated fields: '" + line + "'");
                }
                ArrayList<TaggedWord> terms = (ArrayList<TaggedWord>)map.get(parts[0]);
                if (terms == null) {
                    terms = new ArrayList<TaggedWord>();
                }
                terms.add(new TaggedWord(parts[1], parts[2]));
                map.put(parts[0], terms);
            }
        }
        return map;
    }

    @Override
    public List<TaggedWord> tag(String word) {
        List<TaggedWord> lookedUpTerms = this.mapping.get(word);
        if (lookedUpTerms != null) {
            return Collections.unmodifiableList(lookedUpTerms);
        }
        return Collections.emptyList();
    }
}

