/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.cde.CDE;
import org.eclipse.swt.internal.cde.DtActionArg;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class Program {
    String name = "";
    String command;
    String iconPath;
    Display display;
    boolean gnomeExpectUri;
    static int modTime;
    static Hashtable mimeTable;
    static int cdeShell;
    static final String[] CDE_ICON_EXT;
    static final String[] CDE_MASK_EXT;
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final String ICON_THEME_DATA = "Program_GNOME_ICON_THEME";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_GNOME = 1;
    static final int DESKTOP_GIO = 2;
    static final int DESKTOP_CDE = 3;
    static final int PREFERRED_ICON_SIZE = 16;

    Program() {
    }

    static int getDesktop(final Display display) {
        byte[] byArray;
        int n;
        if (display == null) {
            return 0;
        }
        Integer n2 = (Integer)display.getData(DESKTOP_DATA);
        if (n2 != null) {
            return n2;
        }
        int n3 = 0;
        int n4 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        int n5 = OS.XDefaultRootWindow(n4);
        int[] nArray = new int[1];
        int n6 = OS.XListProperties(n4, n5, nArray);
        int[] nArray2 = new int[nArray[0]];
        if (n6 != 0) {
            OS.memmove(nArray2, n6, nArray2.length * OS.PTR_SIZEOF);
            OS.XFree(n6);
        }
        if (n3 == 0 && (n = OS.XInternAtom(n4, byArray = Converter.wcsToMbcs(null, "_NET_SUPPORTING_WM_CHECK", true), true)) != 0) {
            int n7;
            byte[] byArray2;
            int n8 = OS.RTLD_LAZY;
            if (OS.IsAIX) {
                byArray2 = Converter.wcsToMbcs(null, "libgio-2.0.a(libgio-2.0.so.0)", true);
                n8 |= 0x40000;
            } else {
                byArray2 = OS.IsHPUX ? Converter.wcsToMbcs(null, "libgio-2.0.so", true) : Converter.wcsToMbcs(null, "libgio-2.0.so.0", true);
            }
            int n9 = OS.dlopen(byArray2, n8);
            if (n9 != 0) {
                byArray2 = Converter.wcsToMbcs(null, "g_app_info_launch_default_for_uri", true);
                n7 = OS.dlsym(n9, byArray2);
                if (n7 != 0) {
                    n3 = 2;
                }
                OS.dlclose(n9);
            }
            if (n3 == 0 && Program.gnome_init()) {
                n3 = 1;
                n7 = GNOME.gnome_icon_theme_new();
                display.setData(ICON_THEME_DATA, new LONG(n7));
                display.addListener(12, new Listener(){

                    @Override
                    public void handleEvent(Event event) {
                        LONG lONG = (LONG)display.getData(Program.ICON_THEME_DATA);
                        if (lONG == null) {
                            return;
                        }
                        display.setData(Program.ICON_THEME_DATA, null);
                        if (lONG.value != 0) {
                            OS.g_object_unref(lONG.value);
                        }
                    }
                });
            }
        }
        if (n3 == 0) {
            byArray = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
            n = OS.XInternAtom(n4, byArray, true);
            for (int i = 0; n3 == 0 && i < nArray2.length; ++i) {
                if (nArray2[i] == 0 || nArray2[i] != n || !Program.cde_init(display)) continue;
                n3 = 3;
            }
        }
        display.setData(DESKTOP_DATA, new Integer(n3));
        return n3;
    }

    boolean cde_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.command, true);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        int n = OS.g_malloc(byArray2.length);
        OS.memmove(n, byArray2, byArray2.length);
        DtActionArg dtActionArg = new DtActionArg();
        dtActionArg.argClass = 1;
        dtActionArg.name = n;
        long l = CDE.DtActionInvoke(cdeShell, byArray, dtActionArg, 1, null, null, null, 1, 0, 0);
        OS.g_free(n);
        return l != 0L;
    }

    static String cde_getAction(String string) {
        String string2 = null;
        String string3 = Program.cde_getAttribute(string, "ACTIONS");
        if (string3 != null) {
            int n = string3.indexOf("Open");
            string2 = n != -1 ? string3.substring(n, n + 4) : ((n = string3.indexOf(",")) != -1 ? string3.substring(0, n) : string3);
        }
        return string2;
    }

    static String cde_getAttribute(String string, String string2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
        int n = CDE.DtDtsDataTypeToAttributeValue(byArray3, byArray2 = Converter.wcsToMbcs(null, string2, true), byArray = null);
        if (n == 0) {
            return null;
        }
        int n2 = OS.strlen(n);
        byte[] byArray4 = new byte[n2];
        OS.memmove(byArray4, n, n2);
        CDE.DtDtsFreeAttributeValue(n);
        return new String(Converter.mbcsToWcs(null, byArray4));
    }

    static Hashtable cde_getDataTypeInfo() {
        Hashtable hashtable = new Hashtable();
        int n = CDE.DtDtsDataTypeNames();
        if (n != 0) {
            int n2 = 0;
            int[] nArray = new int[1];
            OS.memmove(nArray, n + n2++ * 4, 4);
            while (nArray[0] != 0) {
                int n3 = OS.strlen(nArray[0]);
                byte[] byArray = new byte[n3];
                OS.memmove(byArray, nArray[0], n3);
                String string = new String(Converter.mbcsToWcs(null, byArray));
                String string2 = Program.cde_getExtension(string);
                if (!CDE.DtDtsDataTypeIsAction(byArray) && string2 != null && Program.cde_getAction(string) != null) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(string2);
                    hashtable.put(string, vector);
                }
                OS.memmove(nArray, n + n2++ * 4, 4);
            }
            CDE.DtDtsFreeDataTypeNames(n);
        }
        return hashtable;
    }

    static String cde_getExtension(String string) {
        String string2 = Program.cde_getAttribute(string, "NAME_TEMPLATE");
        if (string2 == null || string2.indexOf("%s.") == -1) {
            return null;
        }
        int n = string2.indexOf(".");
        return string2.substring(n);
    }

    ImageData cde_getImageData() {
        return null;
    }

    static String cde_getMimeType(String string) {
        String string2 = null;
        Hashtable hashtable = Program.cde_getDataTypeInfo();
        if (hashtable == null) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        block0: while (string2 == null && enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string3);
            for (int i = 0; i < vector.size(); ++i) {
                if (!string.equals(vector.elementAt(i))) continue;
                string2 = string3;
                continue block0;
            }
        }
        return string2;
    }

    static Program cde_getProgram(Display display, String string) {
        String string2 = Program.cde_getAction(string);
        if (string2 == null) {
            return null;
        }
        Program program = new Program();
        program.display = display;
        program.name = string;
        program.command = string2;
        program.iconPath = Program.cde_getAttribute(program.name, "ICON");
        return program;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary("swt-cde");
        }
        catch (Throwable throwable) {
            return false;
        }
        CDE.XtToolkitInitialize();
        int n = CDE.XtCreateApplicationContext();
        int n2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        byte[] byArray = Converter.wcsToMbcs(null, "CDE", true);
        byte[] byArray2 = Converter.wcsToMbcs(null, "CDE", true);
        int[] nArray = new int[]{0};
        CDE.XtDisplayInitialize(n, n2, byArray, byArray2, 0, 0, nArray, 0);
        int n3 = CDE.topLevelShellWidgetClass();
        cdeShell = CDE.XtAppCreateShell(byArray, byArray2, n3, n2, null, 0);
        CDE.XtSetMappedWhenManaged(cdeShell, false);
        CDE.XtResizeWidget(cdeShell, 10, 10, 0);
        CDE.XtRealizeWidget(cdeShell);
        boolean bl = CDE.DtAppInitialize(n, n2, cdeShell, byArray, byArray);
        if (bl) {
            CDE.DtDbLoad();
        }
        return bl;
    }

    static boolean cde_isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        return OS.access(byArray, 1) == 0;
    }

    static String[] parseCommand(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            while (n < string.length() && Compatibility.isWhitespace(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) continue;
            if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                for (n2 = n + 1; n2 < string.length() && string.charAt(n2) != string.charAt(n); ++n2) {
                }
                if (n2 >= string.length()) {
                    vector.addElement(string.substring(n, n2));
                } else {
                    vector.addElement(string.substring(n + 1, n2));
                }
                n = n2 + 1;
                continue;
            }
            for (n2 = n; n2 < string.length() && !Compatibility.isWhitespace(string.charAt(n2)); ++n2) {
            }
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    boolean gnome_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.name, true);
        int n = GNOME.gnome_vfs_mime_get_default_application(byArray);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        int n2 = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray2, 2);
        int n3 = OS.g_list_append(0, n2);
        int n4 = GNOME.gnome_vfs_mime_application_launch(n, n3);
        GNOME.gnome_vfs_mime_application_free(n);
        OS.g_free(n2);
        OS.g_list_free(n3);
        return n4 == 0;
    }

    static boolean gnome_launch(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray, 2);
        int n2 = GNOME.gnome_vfs_url_show(n);
        OS.g_free(n);
        return n2 == 0;
    }

    ImageData gnome_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String gnome_getMimeType(String string) {
        int n;
        String string2 = null;
        String string3 = "swt" + string;
        byte[] byArray = Converter.wcsToMbcs(null, string3, true);
        int n2 = GNOME.gnome_vfs_mime_type_from_name(byArray);
        if (n2 != 0 && (n = OS.strlen(n2)) > 0) {
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, n2, n);
            string2 = new String(Converter.mbcsToWcs(null, byArray2));
        }
        return string2;
    }

    static Program gnome_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = GNOME.gnome_vfs_mime_get_default_application(byArray);
        if (n != 0) {
            byte[] byArray2;
            int n2;
            program = new Program();
            program.display = display;
            program.name = string;
            GnomeVFSMimeApplication gnomeVFSMimeApplication = new GnomeVFSMimeApplication();
            GNOME.memmove(gnomeVFSMimeApplication, n, GnomeVFSMimeApplication.sizeof);
            if (gnomeVFSMimeApplication.command != 0 && (n2 = OS.strlen(gnomeVFSMimeApplication.command)) > 0) {
                byArray2 = new byte[n2];
                OS.memmove(byArray2, gnomeVFSMimeApplication.command, n2);
                program.command = new String(Converter.mbcsToWcs(null, byArray2));
            }
            program.gnomeExpectUri = gnomeVFSMimeApplication.expects_uris == 0;
            n2 = OS.strlen(gnomeVFSMimeApplication.id);
            byArray2 = new byte[n2 + 1];
            OS.memmove(byArray2, gnomeVFSMimeApplication.id, n2);
            LONG lONG = (LONG)display.getData(ICON_THEME_DATA);
            int n3 = GNOME.gnome_icon_lookup(lONG.value, 0, null, byArray2, 0, byArray, 0, null);
            int n4 = 0;
            if (n3 != 0) {
                n4 = GNOME.gnome_icon_theme_lookup_icon(lONG.value, n3, 16, null, null);
            }
            if (n4 != 0) {
                n2 = OS.strlen(n4);
                if (n2 > 0) {
                    byArray2 = new byte[n2];
                    OS.memmove(byArray2, n4, n2);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray2));
                }
                OS.g_free(n4);
            }
            if (n3 != 0) {
                OS.g_free(n3);
            }
            GNOME.gnome_vfs_mime_application_free(n);
        }
        return program != null && program.command != null ? program : null;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean gnome_isExecutable(String string) {
        boolean bl;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (!GNOME.gnome_vfs_is_executable_command_string(byArray)) {
            return false;
        }
        int n = GNOME.gnome_vfs_make_uri_from_input(byArray);
        int n2 = GNOME.gnome_vfs_get_mime_type(n);
        OS.g_free(n);
        byte[] byArray2 = Converter.wcsToMbcs(null, "application/x-executable", true);
        boolean bl2 = bl = GNOME.gnome_vfs_mime_type_get_equivalence(n2, byArray2) != 0;
        if (!bl) {
            byte[] byArray3 = Converter.wcsToMbcs(null, "application/x-shellscript", true);
            bl = GNOME.gnome_vfs_mime_type_get_equivalence(n2, byArray3) == 1;
        }
        return bl;
    }

    public static Program findProgram(String string) {
        return Program.findProgram(Display.getCurrent(), string);
    }

    static Program findProgram(Display display, String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        int n = Program.getDesktop(display);
        String string2 = null;
        switch (n) {
            case 2: {
                string2 = Program.gio_getMimeType(string);
                break;
            }
            case 1: {
                string2 = Program.gnome_getMimeType(string);
                break;
            }
            case 3: {
                string2 = Program.cde_getMimeType(string);
            }
        }
        if (string2 == null) {
            return null;
        }
        Program program = null;
        switch (n) {
            case 2: {
                program = Program.gio_getProgram(display, string2);
                break;
            }
            case 1: {
                program = Program.gnome_getProgram(display, string2);
                break;
            }
            case 3: {
                program = Program.cde_getProgram(display, string2);
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        String[] stringArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 2: {
                return Program.gio_getExtensions();
            }
            case 1: {
                break;
            }
            case 3: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new String[0];
        }
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(stringArray);
            for (int i = 0; i < vector2.size(); ++i) {
                if (vector.contains(vector2.elementAt(i))) continue;
                vector.addElement(vector2.elementAt(i));
            }
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        Program[] programArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 2: {
                return Program.gio_getPrograms(display);
            }
            case 1: {
                break;
            }
            case 3: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new Program[0];
        }
        Vector<Program> vector = new Vector<Program>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            programArray = (Program[])enumeration.nextElement();
            Program program = null;
            switch (n) {
                case 3: {
                    program = Program.cde_getProgram(display, (String)programArray);
                }
            }
            if (program == null) continue;
            vector.addElement(program);
        }
        programArray = new Program[vector.size()];
        for (int i = 0; i < programArray.length; ++i) {
            programArray[i] = (Program)vector.elementAt(i);
        }
        return programArray;
    }

    ImageData gio_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        ImageData imageData = null;
        int n = OS.gtk_icon_theme_get_default();
        byte[] byArray = Converter.wcsToMbcs(null, this.iconPath, true);
        int n2 = OS.g_icon_new_for_string(byArray, null);
        if (n2 != 0) {
            int n3 = OS.gtk_icon_theme_lookup_by_gicon(n, n2, 16, 0);
            if (n3 != 0) {
                int n4 = OS.gtk_icon_info_load_icon(n3, null);
                if (n4 != 0) {
                    int n5 = OS.gdk_pixbuf_get_rowstride(n4);
                    int n6 = OS.gdk_pixbuf_get_pixels(n4);
                    int n7 = OS.gdk_pixbuf_get_height(n4);
                    int n8 = OS.gdk_pixbuf_get_width(n4);
                    boolean bl = OS.gdk_pixbuf_get_has_alpha(n4);
                    byte[] byArray2 = new byte[n5 * n7];
                    OS.memmove(byArray2, n6, byArray2.length);
                    OS.g_object_unref(n4);
                    if (bl) {
                        PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
                        imageData = new ImageData(n8, n7, 32, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n5;
                        int n9 = 3;
                        int n10 = 0;
                        byte[] byArray3 = new byte[n8 * n7];
                        for (int i = 0; i < n7; ++i) {
                            for (int j = 0; j < n8; ++j) {
                                byArray3[n10++] = byArray2[n9];
                                byArray2[n9] = 0;
                                n9 += 4;
                            }
                        }
                        imageData.alphaData = byArray3;
                    } else {
                        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
                        imageData = new ImageData(n8, n7, 24, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n5;
                    }
                }
                OS.gtk_icon_info_free(n3);
            }
            OS.g_object_unref(n2);
        }
        return imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hashtable gio_getMimeInfo() {
        int n = 0;
        int n2 = 0;
        byte[] byArray = Converter.wcsToMbcs(null, "/usr/share/mime/globs", true);
        n = OS.g_file_new_for_path(byArray);
        int n3 = OS.g_file_read(n, 0, 0);
        try {
            if (n3 != 0) {
                int[] nArray = new int[2];
                byArray = Converter.wcsToMbcs(null, "*", true);
                n2 = OS.g_file_query_info(n, byArray, 0, 0, 0);
                OS.g_file_info_get_modification_time(n2, nArray);
                if (modTime != 0 && nArray[0] == modTime) {
                    Hashtable hashtable = mimeTable;
                    return hashtable;
                }
                mimeTable = new Hashtable();
                modTime = nArray[0];
                int n4 = OS.g_data_input_stream_new(n3);
                int[] nArray2 = new int[1];
                if (n4 != 0) {
                    int n5 = OS.g_data_input_stream_read_line(n4, nArray2, 0, 0);
                    while (n5 != 0) {
                        byte[] byArray2 = new byte[nArray2[0]];
                        OS.memmove(byArray2, n5, nArray2[0]);
                        String string = new String(Converter.mbcsToWcs(null, byArray2));
                        int n6 = string.indexOf(58);
                        if (n6 > 0) {
                            Vector<String> vector = new Vector<String>();
                            String string2 = string.substring(0, n6);
                            String string3 = string.substring(n6 + 1);
                            int n7 = string3.indexOf(".");
                            if (n7 > 0) {
                                String string4 = string3.substring(n7);
                                if (mimeTable.containsKey(string4)) {
                                    Vector vector2 = (Vector)mimeTable.get(string4);
                                    vector.addAll(vector2);
                                }
                                vector.add(string2);
                                mimeTable.put(string4, vector);
                            }
                        }
                        OS.g_free(n5);
                        n5 = OS.g_data_input_stream_read_line(n4, nArray2, 0, 0);
                    }
                }
                if (n4 != 0) {
                    OS.g_object_unref(n4);
                }
                Hashtable hashtable = mimeTable;
                return hashtable;
            }
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            if (n2 != 0) {
                OS.g_object_unref(n2);
            }
            if (n3 != 0) {
                OS.g_object_unref(n3);
            }
            if (n != 0) {
                OS.g_object_unref(n);
            }
        }
    }

    static String gio_getMimeType(String string) {
        String string2 = null;
        Hashtable hashtable = Program.gio_getMimeInfo();
        if (hashtable != null && hashtable.containsKey(string)) {
            Vector vector = (Vector)hashtable.get(string);
            string2 = (String)vector.get(0);
        }
        return string2;
    }

    static Program gio_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = OS.g_app_info_get_default_for_type(byArray, false);
        if (n != 0) {
            program = Program.gio_getProgram(display, n);
        }
        return program;
    }

    static Program gio_getProgram(Display display, int n) {
        int n2;
        byte[] byArray;
        int n3;
        Program program = new Program();
        program.display = display;
        int n4 = OS.g_app_info_get_name(n);
        if (n4 != 0 && (n3 = OS.strlen(n4)) > 0) {
            byArray = new byte[n3];
            OS.memmove(byArray, n4, n3);
            program.name = new String(Converter.mbcsToWcs(null, byArray));
        }
        if ((n2 = OS.g_app_info_get_executable(n)) != 0 && (n3 = OS.strlen(n2)) > 0) {
            byArray = new byte[n3];
            OS.memmove(byArray, n2, n3);
            program.command = new String(Converter.mbcsToWcs(null, byArray));
        }
        program.gnomeExpectUri = OS.g_app_info_supports_uris(n);
        int n5 = OS.g_app_info_get_icon(n);
        if (n5 != 0) {
            int n6 = OS.g_icon_to_string(n5);
            if (n6 != 0) {
                n3 = OS.strlen(n6);
                if (n3 > 0) {
                    byArray = new byte[n3];
                    OS.memmove(byArray, n6, n3);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray));
                }
                OS.g_free(n6);
            }
            OS.g_object_unref(n5);
        }
        return program.command != null ? program : null;
    }

    static Program[] gio_getPrograms(Display display) {
        int n;
        int n2 = n = OS.g_app_info_get_all();
        Vector<Program> vector = new Vector<Program>();
        while (n2 != 0) {
            Program program;
            int n3 = OS.g_list_data(n2);
            if (n3 != 0 && (program = Program.gio_getProgram(display, n3)) != null) {
                vector.addElement(program);
            }
            n2 = OS.g_list_next(n2);
        }
        if (n != 0) {
            OS.g_list_free(n);
        }
        Program[] programArray = new Program[vector.size()];
        for (int i = 0; i < programArray.length; ++i) {
            programArray[i] = (Program)vector.elementAt(i);
        }
        return programArray;
    }

    static boolean gio_isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.g_file_test(byArray, 4)) {
            return false;
        }
        if (!OS.g_file_test(byArray, 8)) {
            return false;
        }
        int n = OS.g_file_new_for_path(byArray);
        boolean bl = false;
        if (n != 0) {
            byte[] byArray2 = Converter.wcsToMbcs(null, "*", true);
            int n2 = OS.g_file_query_info(n, byArray2, 0, 0, 0);
            if (n2 != 0) {
                byte[] byArray3;
                int n3 = OS.g_file_info_get_content_type(n2);
                if (n3 != 0 && !(bl = OS.g_content_type_is_a(n3, byArray3 = Converter.wcsToMbcs(null, "application/x-executable", true)))) {
                    byte[] byArray4 = Converter.wcsToMbcs(null, "application/x-shellscript", true);
                    bl = OS.g_content_type_equals(n3, byArray4);
                }
                OS.g_object_unref(n2);
            }
            OS.g_object_unref(n);
        }
        return bl;
    }

    static boolean gio_launch(String string) {
        boolean bl = false;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = OS.g_file_new_for_commandline_arg(byArray);
        if (n != 0) {
            int n2 = OS.g_file_get_uri(n);
            if (n2 != 0) {
                bl = OS.g_app_info_launch_default_for_uri(n2, 0, 0);
                OS.g_free(n2);
            }
            OS.g_object_unref(n);
        }
        return bl;
    }

    boolean gio_execute(String string) {
        byte[] byArray;
        boolean bl = false;
        byte[] byArray2 = Converter.wcsToMbcs(null, this.command, true);
        int n = OS.g_app_info_create_from_commandline(byArray2, byArray = Converter.wcsToMbcs(null, this.name, true), this.gnomeExpectUri ? 2 : 0, 0);
        if (n != 0) {
            byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
            int n2 = 0;
            if (string.length() > 0) {
                n2 = OS.g_app_info_supports_uris(n) ? OS.g_file_new_for_uri(byArray3) : OS.g_file_new_for_path(byArray3);
            }
            int n3 = 0;
            if (n2 != 0) {
                n3 = OS.g_list_append(0, n2);
            }
            bl = OS.g_app_info_launch(n, n3, 0, 0);
            if (n3 != 0) {
                OS.g_list_free(n3);
                OS.g_object_unref(n2);
            }
            OS.g_object_unref(n);
        }
        return bl;
    }

    static String[] gio_getExtensions() {
        String[] stringArray;
        Hashtable hashtable = Program.gio_getMimeInfo();
        if (hashtable == null) {
            return new String[0];
        }
        Vector<String[]> vector = new Vector<String[]>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    static boolean isExecutable(Display display, String string) {
        switch (Program.getDesktop(display)) {
            case 2: {
                return Program.gio_isExecutable(string);
            }
            case 1: {
                return Program.gnome_isExecutable(string);
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static boolean launch(String string) {
        return Program.launch(Display.getCurrent(), string, null);
    }

    public static boolean launch(String string, String string2) {
        return Program.launch(Display.getCurrent(), string, string2);
    }

    static boolean launch(Display display, String string, String string2) {
        String string3;
        Program program;
        if (string == null) {
            SWT.error(4);
        }
        if (string2 != null && Program.isExecutable(display, string)) {
            try {
                Compatibility.exec(new String[]{string}, null, string2);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        switch (Program.getDesktop(display)) {
            case 2: {
                if (Program.gio_launch(string)) {
                    return true;
                }
            }
            case 1: {
                if (!Program.gnome_launch(string)) break;
                return true;
            }
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && (program = Program.findProgram(display, string3 = string.substring(n))) != null && program.execute(string)) {
            return true;
        }
        string3 = string.toLowerCase();
        if (string3.startsWith(PREFIX_HTTP) || string3.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(string)) {
                return true;
            }
        }
        try {
            Compatibility.exec(new String[]{string}, null, string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program program = (Program)object;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = Program.getDesktop(this.display);
        switch (n) {
            case 2: {
                return this.gio_execute(string);
            }
            case 1: {
                return this.gnome_execute(string);
            }
            case 3: {
                return this.cde_execute(string);
            }
        }
        return false;
    }

    public ImageData getImageData() {
        switch (Program.getDesktop(this.display)) {
            case 2: {
                return this.gio_getImageData();
            }
            case 1: {
                return this.gnome_getImageData();
            }
            case 3: {
                return this.cde_getImageData();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }

    static {
        CDE_ICON_EXT = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
        CDE_MASK_EXT = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    }
}

