/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.DocIdSetBuilder;

public abstract class AbstractPrefixTreeFilter
extends Filter {
    protected final Shape queryShape;
    protected final String fieldName;
    protected final SpatialPrefixTree grid;
    protected final int detailLevel;

    public AbstractPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel) {
        this.queryShape = queryShape;
        this.fieldName = fieldName;
        this.grid = grid;
        this.detailLevel = detailLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractPrefixTreeFilter that = (AbstractPrefixTreeFilter)((Object)o);
        if (this.detailLevel != that.detailLevel) {
            return false;
        }
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.queryShape.equals((Object)that.queryShape);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.queryShape.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.detailLevel;
        return result;
    }

    private static PostingsEnum wrap(PostingsEnum iterator, Bits acceptDocs) {
        if (iterator == null || acceptDocs == null) {
            return iterator;
        }
        return new BitsFilteredPostingsEnum(iterator, acceptDocs);
    }

    private static class BitsFilteredPostingsEnum
    extends FilterLeafReader.FilterPostingsEnum {
        private final Bits bits;

        private BitsFilteredPostingsEnum(PostingsEnum in, Bits bits) {
            super(in);
            this.bits = bits;
        }

        private int doNext(int doc) throws IOException {
            while (doc != Integer.MAX_VALUE && !this.bits.get(doc)) {
                doc = this.in.nextDoc();
            }
            return doc;
        }

        public int nextDoc() throws IOException {
            return this.doNext(this.in.nextDoc());
        }

        public int advance(int target) throws IOException {
            return this.doNext(this.in.advance(target));
        }
    }

    public abstract class BaseTermsEnumTraverser {
        protected final LeafReaderContext context;
        protected Bits acceptDocs;
        protected final int maxDoc;
        protected TermsEnum termsEnum;
        protected PostingsEnum postingsEnum;

        public BaseTermsEnumTraverser(LeafReaderContext context, Bits acceptDocs) throws IOException {
            this.context = context;
            LeafReader reader = context.reader();
            this.acceptDocs = acceptDocs;
            this.maxDoc = reader.maxDoc();
            Terms terms = reader.terms(AbstractPrefixTreeFilter.this.fieldName);
            if (terms != null) {
                this.termsEnum = terms.iterator();
            }
        }

        protected void collectDocs(BitSet bitSet) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            bitSet.or((DocIdSetIterator)AbstractPrefixTreeFilter.wrap(this.postingsEnum, this.acceptDocs));
        }

        protected void collectDocs(DocIdSetBuilder docSetBuilder) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            docSetBuilder.add((DocIdSetIterator)AbstractPrefixTreeFilter.wrap(this.postingsEnum, this.acceptDocs));
        }
    }
}

