/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.PluginsInfo;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.transport.TransportInfo;

public class NodeInfo
extends BaseNodeResponse {
    @Nullable
    private ImmutableMap<String, String> serviceAttributes;
    private Version version;
    private Build build;
    @Nullable
    private Settings settings;
    @Nullable
    private OsInfo os;
    @Nullable
    private ProcessInfo process;
    @Nullable
    private JvmInfo jvm;
    @Nullable
    private ThreadPoolInfo threadPool;
    @Nullable
    private TransportInfo transport;
    @Nullable
    private HttpInfo http;
    @Nullable
    private PluginsInfo plugins;

    NodeInfo() {
    }

    public NodeInfo(Version version, Build build, DiscoveryNode node, @Nullable ImmutableMap<String, String> serviceAttributes, @Nullable Settings settings, @Nullable OsInfo os, @Nullable ProcessInfo process, @Nullable JvmInfo jvm, @Nullable ThreadPoolInfo threadPool, @Nullable TransportInfo transport, @Nullable HttpInfo http, @Nullable PluginsInfo plugins) {
        super(node);
        this.version = version;
        this.build = build;
        this.serviceAttributes = serviceAttributes;
        this.settings = settings;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.transport = transport;
        this.http = http;
        this.plugins = plugins;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    public Version getVersion() {
        return this.version;
    }

    public Build getBuild() {
        return this.build;
    }

    @Nullable
    public ImmutableMap<String, String> getServiceAttributes() {
        return this.serviceAttributes;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public OsInfo getOs() {
        return this.os;
    }

    @Nullable
    public ProcessInfo getProcess() {
        return this.process;
    }

    @Nullable
    public JvmInfo getJvm() {
        return this.jvm;
    }

    @Nullable
    public ThreadPoolInfo getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public TransportInfo getTransport() {
        return this.transport;
    }

    @Nullable
    public HttpInfo getHttp() {
        return this.http;
    }

    @Nullable
    public PluginsInfo getPlugins() {
        return this.plugins;
    }

    public static NodeInfo readNodeInfo(StreamInput in) throws IOException {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.readFrom(in);
        return nodeInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.version = Version.readVersion(in);
        this.build = Build.readBuild(in);
        if (in.readBoolean()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                builder.put((Object)in.readString(), (Object)in.readString());
            }
            this.serviceAttributes = builder.build();
        }
        if (in.readBoolean()) {
            this.settings = Settings.readSettingsFromStream(in);
        }
        if (in.readBoolean()) {
            this.os = OsInfo.readOsInfo(in);
        }
        if (in.readBoolean()) {
            this.process = ProcessInfo.readProcessInfo(in);
        }
        if (in.readBoolean()) {
            this.jvm = JvmInfo.readJvmInfo(in);
        }
        if (in.readBoolean()) {
            this.threadPool = ThreadPoolInfo.readThreadPoolInfo(in);
        }
        if (in.readBoolean()) {
            this.transport = TransportInfo.readTransportInfo(in);
        }
        if (in.readBoolean()) {
            this.http = HttpInfo.readHttpInfo(in);
        }
        if (in.readBoolean()) {
            this.plugins = PluginsInfo.readPluginsInfo(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.version.id);
        Build.writeBuild(this.build, out);
        if (this.getServiceAttributes() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.serviceAttributes.size());
            for (Map.Entry entry : this.serviceAttributes.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeString((String)entry.getValue());
            }
        }
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Settings.writeSettingsToStream(this.settings, out);
        }
        if (this.os == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.os.writeTo(out);
        }
        if (this.process == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.process.writeTo(out);
        }
        if (this.jvm == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.jvm.writeTo(out);
        }
        if (this.threadPool == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.threadPool.writeTo(out);
        }
        if (this.transport == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.transport.writeTo(out);
        }
        if (this.http == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.http.writeTo(out);
        }
        if (this.plugins == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.plugins.writeTo(out);
        }
    }
}

