/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterRerouteAction
extends TransportMasterNodeAction<ClusterRerouteRequest, ClusterRerouteResponse> {
    private final AllocationService allocationService;

    @Inject
    public TransportClusterRerouteAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/reroute", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterRerouteRequest.class);
        this.allocationService = allocationService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterRerouteRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterRerouteResponse newResponse() {
        return new ClusterRerouteResponse();
    }

    @Override
    protected void masterOperation(final ClusterRerouteRequest request, ClusterState state, final ActionListener<ClusterRerouteResponse> listener) {
        this.clusterService.submitStateUpdateTask("cluster_reroute (api)", Priority.IMMEDIATE, new AckedClusterStateUpdateTask<ClusterRerouteResponse>((AckedRequest)request, listener){
            private volatile ClusterState clusterStateToSend;
            private volatile RoutingExplanations explanations;

            @Override
            protected ClusterRerouteResponse newResponse(boolean acknowledged) {
                return new ClusterRerouteResponse(acknowledged, this.clusterStateToSend, this.explanations);
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterRerouteResponse(false, this.clusterStateToSend, new RoutingExplanations()));
            }

            @Override
            public void onFailure(String source, Throwable t) {
                TransportClusterRerouteAction.this.logger.debug("failed to perform [{}]", t, source);
                super.onFailure(source, t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState newState;
                RoutingAllocation.Result routingResult = TransportClusterRerouteAction.this.allocationService.reroute(currentState, request.commands, request.explain());
                this.clusterStateToSend = newState = ClusterState.builder(currentState).routingResult(routingResult).build();
                this.explanations = routingResult.explanations();
                if (request.dryRun) {
                    return currentState;
                }
                return newState;
            }
        });
    }
}

