/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.exists;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;

@Deprecated
public class ExistsRequest
extends BroadcastRequest<ExistsRequest> {
    public static final float DEFAULT_MIN_SCORE = -1.0f;
    private float minScore = -1.0f;
    @Nullable
    protected String routing;
    @Nullable
    private String preference;
    private BytesReference source;
    private String[] types = Strings.EMPTY_ARRAY;
    long nowInMillis;

    ExistsRequest() {
    }

    public ExistsRequest(String ... indices) {
        super(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        return validationException;
    }

    public float minScore() {
        return this.minScore;
    }

    public ExistsRequest minScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ExistsRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ExistsRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public ExistsRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public BytesReference source() {
        return this.source;
    }

    public ExistsRequest source(QuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public ExistsRequest source(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(querySource);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    public ExistsRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        return this;
    }

    public ExistsRequest source(String querySource) {
        this.source = new BytesArray(querySource);
        return this;
    }

    public ExistsRequest source(byte[] querySource) {
        return this.source(querySource, 0, querySource.length);
    }

    public ExistsRequest source(byte[] querySource, int offset, int length) {
        return this.source(new BytesArray(querySource, offset, length));
    }

    public ExistsRequest source(BytesReference querySource) {
        this.source = querySource;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public ExistsRequest types(String ... types) {
        this.types = types;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.minScore = in.readFloat();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.source = in.readBytesReference();
        this.types = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.source);
        out.writeStringArray(this.types);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", source[" + sSource + "]";
    }
}

