/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;

public enum SearchType {
    DFS_QUERY_THEN_FETCH(0),
    QUERY_THEN_FETCH(1),
    DFS_QUERY_AND_FETCH(2),
    QUERY_AND_FETCH(3),
    SCAN(4),
    COUNT(5);

    public static final SearchType DEFAULT;
    private static final ParseField COUNT_VALUE;
    private static final ParseField SCAN_VALUE;
    private byte id;

    private SearchType(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static SearchType fromId(byte id) {
        if (id == 0) {
            return DFS_QUERY_THEN_FETCH;
        }
        if (id == 1) {
            return QUERY_THEN_FETCH;
        }
        if (id == 2) {
            return DFS_QUERY_AND_FETCH;
        }
        if (id == 3) {
            return QUERY_AND_FETCH;
        }
        if (id == 4) {
            return SCAN;
        }
        if (id == 5) {
            return COUNT;
        }
        throw new IllegalArgumentException("No search type for [" + id + "]");
    }

    public static SearchType fromString(String searchType, ParseFieldMatcher parseFieldMatcher) {
        if (searchType == null) {
            return DEFAULT;
        }
        if ("dfs_query_then_fetch".equals(searchType)) {
            return DFS_QUERY_THEN_FETCH;
        }
        if ("dfs_query_and_fetch".equals(searchType)) {
            return DFS_QUERY_AND_FETCH;
        }
        if ("query_then_fetch".equals(searchType)) {
            return QUERY_THEN_FETCH;
        }
        if ("query_and_fetch".equals(searchType)) {
            return QUERY_AND_FETCH;
        }
        if (parseFieldMatcher.match(searchType, SCAN_VALUE)) {
            return SCAN;
        }
        if (parseFieldMatcher.match(searchType, COUNT_VALUE)) {
            return COUNT;
        }
        throw new IllegalArgumentException("No search type for [" + searchType + "]");
    }

    static {
        DEFAULT = QUERY_THEN_FETCH;
        COUNT_VALUE = new ParseField("count", new String[0]).withAllDeprecated("query_then_fetch");
        SCAN_VALUE = new ParseField("scan", new String[0]).withAllDeprecated("query_then_fetch sorting on `_doc`");
    }
}

