/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import com.carrotsearch.hppc.IntSet;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.cluster.routing.RoutingValidationException;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexNotFoundException;

public class RoutingTable
implements Iterable<IndexRoutingTable>,
Diffable<RoutingTable> {
    public static RoutingTable PROTO = RoutingTable.builder().build();
    public static final RoutingTable EMPTY_ROUTING_TABLE = RoutingTable.builder().build();
    private final long version;
    private final ImmutableMap<String, IndexRoutingTable> indicesRouting;
    private static Predicate<ShardRouting> ACTIVE_PREDICATE = new Predicate<ShardRouting>(){

        public boolean apply(ShardRouting shardRouting) {
            return shardRouting.active();
        }
    };
    private static Predicate<ShardRouting> ASSIGNED_PREDICATE = new Predicate<ShardRouting>(){

        public boolean apply(ShardRouting shardRouting) {
            return shardRouting.assignedToNode();
        }
    };

    RoutingTable(long version, Map<String, IndexRoutingTable> indicesRouting) {
        this.version = version;
        this.indicesRouting = ImmutableMap.copyOf(indicesRouting);
    }

    public long version() {
        return this.version;
    }

    @Override
    public UnmodifiableIterator<IndexRoutingTable> iterator() {
        return this.indicesRouting.values().iterator();
    }

    public boolean hasIndex(String index) {
        return this.indicesRouting.containsKey((Object)index);
    }

    public IndexRoutingTable index(String index) {
        return (IndexRoutingTable)this.indicesRouting.get((Object)index);
    }

    public Map<String, IndexRoutingTable> indicesRouting() {
        return this.indicesRouting;
    }

    public Map<String, IndexRoutingTable> getIndicesRouting() {
        return this.indicesRouting();
    }

    public RoutingTable validateRaiseException(MetaData metaData) throws RoutingValidationException {
        RoutingTableValidation validation = this.validate(metaData);
        if (!validation.valid()) {
            throw new RoutingValidationException(validation);
        }
        return this;
    }

    public RoutingTableValidation validate(MetaData metaData) {
        RoutingTableValidation validation = new RoutingTableValidation();
        for (IndexRoutingTable indexRoutingTable : this) {
            indexRoutingTable.validate(validation, metaData);
        }
        return validation;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexRoutingTable indexRoutingTable : this) {
            shards.addAll(indexRoutingTable.shardsWithState(state));
        }
        return shards;
    }

    public List<ShardRouting> allShards() {
        String[] indices;
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (String index : indices = (String[])this.indicesRouting.keySet().toArray((Object[])new String[this.indicesRouting.keySet().size()])) {
            List<ShardRouting> allShardsIndex = this.allShards(index);
            shards.addAll(allShardsIndex);
        }
        return shards;
    }

    public List<ShardRouting> allShards(String index) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        IndexRoutingTable indexRoutingTable = this.index(index);
        if (indexRoutingTable == null) {
            throw new IndexNotFoundException(index);
        }
        for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                shards.add(shardRouting);
            }
        }
        return shards;
    }

    public GroupShardsIterator allActiveShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allActiveShardsGrouped(indices, includeEmpty, false);
    }

    public GroupShardsIterator allActiveShardsGrouped(String[] indices, boolean includeEmpty, boolean includeRelocationTargets) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, includeRelocationTargets, ACTIVE_PREDICATE);
    }

    public GroupShardsIterator allAssignedShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allAssignedShardsGrouped(indices, includeEmpty, false);
    }

    public GroupShardsIterator allAssignedShardsGrouped(String[] indices, boolean includeEmpty, boolean includeRelocationTargets) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, includeRelocationTargets, ASSIGNED_PREDICATE);
    }

    private GroupShardsIterator allSatisfyingPredicateShardsGrouped(String[] indices, boolean includeEmpty, boolean includeRelocationTargets, Predicate<ShardRouting> predicate) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (predicate.apply((Object)shardRouting)) {
                        set.add(shardRouting.shardsIt());
                        if (!includeRelocationTargets || !shardRouting.relocating()) continue;
                        set.add(new PlainShardIterator(shardRouting.shardId(), Collections.singletonList(shardRouting.buildTargetRelocatingShard())));
                        continue;
                    }
                    if (!includeEmpty) continue;
                    set.add(new PlainShardIterator(shardRouting.shardId(), Collections.emptyList()));
                }
            }
        }
        return new GroupShardsIterator(set);
    }

    public ShardsIterator allShards(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, (Predicate<ShardRouting>)Predicates.alwaysTrue(), false);
    }

    public ShardsIterator allShardsIncludingRelocationTargets(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, (Predicate<ShardRouting>)Predicates.alwaysTrue(), true);
    }

    private ShardsIterator allShardsSatisfyingPredicate(String[] indices, Predicate<ShardRouting> predicate, boolean includeRelocationTargets) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (!predicate.apply((Object)shardRouting)) continue;
                    shards.add(shardRouting);
                    if (!includeRelocationTargets || !shardRouting.relocating()) continue;
                    shards.add(shardRouting.buildTargetRelocatingShard());
                }
            }
        }
        return new PlainShardsIterator(shards);
    }

    public GroupShardsIterator activePrimaryShardsGrouped(String[] indices, boolean includeEmpty) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) {
                throw new IndexNotFoundException(index);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                ShardRouting primary = indexShardRoutingTable.primaryShard();
                if (primary.active()) {
                    set.add(primary.shardsIt());
                    continue;
                }
                if (!includeEmpty) continue;
                set.add(new PlainShardIterator(primary.shardId(), Collections.emptyList()));
            }
        }
        return new GroupShardsIterator(set);
    }

    @Override
    public Diff<RoutingTable> diff(RoutingTable previousState) {
        return new RoutingTableDiff(previousState, this);
    }

    @Override
    public Diff<RoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return new RoutingTableDiff(in);
    }

    @Override
    public RoutingTable readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder();
        builder.version = in.readLong();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            IndexRoutingTable index = IndexRoutingTable.Builder.readFrom(in);
            builder.add(index);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeVInt(this.indicesRouting.size());
        for (IndexRoutingTable index : this.indicesRouting.values()) {
            index.writeTo(out);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RoutingTable routingTable) {
        return new Builder(routingTable);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("routing_table (version ").append(this.version).append("):\n");
        for (Map.Entry entry : this.indicesRouting.entrySet()) {
            sb.append(((IndexRoutingTable)entry.getValue()).prettyPrint()).append('\n');
        }
        return sb.toString();
    }

    public static class Builder {
        private long version;
        private final Map<String, IndexRoutingTable> indicesRouting = Maps.newHashMap();

        public Builder() {
        }

        public Builder(RoutingTable routingTable) {
            this.version = routingTable.version;
            for (IndexRoutingTable indexRoutingTable : routingTable) {
                this.indicesRouting.put(indexRoutingTable.index(), indexRoutingTable);
            }
        }

        public Builder updateNodes(RoutingNodes routingNodes) {
            this.version = routingNodes.routingTable().version();
            HashMap indexRoutingTableBuilders = Maps.newHashMap();
            for (RoutingNode routingNode : routingNodes) {
                for (ShardRouting shardRoutingEntry : routingNode) {
                    if (shardRoutingEntry.initializing() && shardRoutingEntry.relocatingNodeId() != null) continue;
                    String index = shardRoutingEntry.index();
                    IndexRoutingTable.Builder indexBuilder = (IndexRoutingTable.Builder)indexRoutingTableBuilders.get(index);
                    if (indexBuilder == null) {
                        indexBuilder = new IndexRoutingTable.Builder(index);
                        indexRoutingTableBuilders.put(index, indexBuilder);
                    }
                    IndexShardRoutingTable refData = routingNodes.routingTable().index(shardRoutingEntry.index()).shard(shardRoutingEntry.id());
                    indexBuilder.addShard(refData, shardRoutingEntry);
                }
            }
            for (ShardRouting shardRoutingEntry : Iterables.concat((Iterable)routingNodes.unassigned(), routingNodes.unassigned().ignored())) {
                String index = shardRoutingEntry.index();
                IndexRoutingTable.Builder indexBuilder = (IndexRoutingTable.Builder)indexRoutingTableBuilders.get(index);
                if (indexBuilder == null) {
                    indexBuilder = new IndexRoutingTable.Builder(index);
                    indexRoutingTableBuilders.put(index, indexBuilder);
                }
                IndexShardRoutingTable refData = routingNodes.routingTable().index(shardRoutingEntry.index()).shard(shardRoutingEntry.id());
                indexBuilder.addShard(refData, shardRoutingEntry);
            }
            for (IndexRoutingTable.Builder indexBuilder : indexRoutingTableBuilders.values()) {
                this.add(indexBuilder);
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indicesRouting.keySet().toArray(new String[this.indicesRouting.keySet().size()]);
            }
            for (String index : indices) {
                int delta;
                IndexRoutingTable indexRoutingTable = this.indicesRouting.get(index);
                if (indexRoutingTable == null) continue;
                int currentNumberOfReplicas = indexRoutingTable.shards().get(0).size() - 1;
                IndexRoutingTable.Builder builder = new IndexRoutingTable.Builder(index);
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.addIndexShard(indexShardRoutingTable);
                }
                if (currentNumberOfReplicas < numberOfReplicas) {
                    for (int i = 0; i < numberOfReplicas - currentNumberOfReplicas; ++i) {
                        builder.addReplica();
                    }
                } else if (currentNumberOfReplicas > numberOfReplicas && (delta = currentNumberOfReplicas - numberOfReplicas) > 0) {
                    for (int i = 0; i < delta; ++i) {
                        builder.removeReplica();
                    }
                }
                this.indicesRouting.put(index, builder.build());
            }
            return this;
        }

        public Builder addAsNew(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsNew(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRecovery(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsRecovery(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromDangling(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsFromDangling(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromCloseToOpen(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsFromCloseToOpen(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRestore(IndexMetaData indexMetaData, RestoreSource restoreSource) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsRestore(indexMetaData, restoreSource);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder addAsNewRestore(IndexMetaData indexMetaData, RestoreSource restoreSource, IntSet ignoreShards) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsNewRestore(indexMetaData, restoreSource, ignoreShards);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder add(IndexRoutingTable indexRoutingTable) {
            indexRoutingTable.validate();
            this.indicesRouting.put(indexRoutingTable.index(), indexRoutingTable);
            return this;
        }

        public Builder add(IndexRoutingTable.Builder indexRoutingTableBuilder) {
            this.add(indexRoutingTableBuilder.build());
            return this;
        }

        public Builder indicesRouting(ImmutableMap<String, IndexRoutingTable> indicesRouting) {
            this.indicesRouting.putAll((Map<String, IndexRoutingTable>)indicesRouting);
            return this;
        }

        public Builder remove(String index) {
            this.indicesRouting.remove(index);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public RoutingTable build() {
            for (IndexRoutingTable indexRoutingTable : this.indicesRouting.values()) {
                this.indicesRouting.put(indexRoutingTable.index(), indexRoutingTable.normalizeVersions());
            }
            return new RoutingTable(this.version, this.indicesRouting);
        }

        public static RoutingTable readFrom(StreamInput in) throws IOException {
            return PROTO.readFrom(in);
        }
    }

    private static class RoutingTableDiff
    implements Diff<RoutingTable> {
        private final long version;
        private final Diff<ImmutableMap<String, IndexRoutingTable>> indicesRouting;

        public RoutingTableDiff(RoutingTable before, RoutingTable after) {
            this.version = after.version;
            this.indicesRouting = DiffableUtils.diff(before.indicesRouting, after.indicesRouting);
        }

        public RoutingTableDiff(StreamInput in) throws IOException {
            this.version = in.readLong();
            this.indicesRouting = DiffableUtils.readImmutableMapDiff(in, IndexRoutingTable.PROTO);
        }

        @Override
        public RoutingTable apply(RoutingTable part) {
            return new RoutingTable(this.version, (Map)this.indicesRouting.apply((ImmutableMap<String, IndexRoutingTable>)part.indicesRouting));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.version);
            this.indicesRouting.writeTo(out);
        }
    }
}

