/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;

public class FailedRerouteAllocation
extends RoutingAllocation {
    private final List<FailedShard> failedShards;

    public FailedRerouteAllocation(AllocationDeciders deciders, RoutingNodes routingNodes, DiscoveryNodes nodes, List<FailedShard> failedShards, ClusterInfo clusterInfo) {
        super(deciders, routingNodes, nodes, clusterInfo);
        this.failedShards = failedShards;
    }

    public List<FailedShard> failedShards() {
        return this.failedShards;
    }

    public static class FailedShard {
        public final ShardRouting shard;
        public final String message;
        public final Throwable failure;

        public FailedShard(ShardRouting shard, String message, Throwable failure) {
            this.shard = shard;
            this.message = message;
            this.failure = failure;
        }

        public String toString() {
            return "failed shard, shard " + this.shard + ", message [" + this.message + "], failure [" + ExceptionsHelper.detailedMessage(this.failure) + "]";
        }
    }
}

