/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.MultiValueMode;

abstract class AbstractIndexGeoPointFieldData
extends AbstractIndexFieldData<AtomicGeoPointFieldData>
implements IndexGeoPointFieldData {
    public AbstractIndexGeoPointFieldData(Index index, Settings indexSettings, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public final IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    @Override
    protected AtomicGeoPointFieldData empty(int maxDoc) {
        return AbstractAtomicGeoPointFieldData.empty(maxDoc);
    }

    protected static class GeoPointEnum {
        private final BytesRefIterator termsEnum;
        private final GeoPoint next;
        private final CharsRefBuilder spare;

        protected GeoPointEnum(BytesRefIterator termsEnum) {
            this.termsEnum = termsEnum;
            this.next = new GeoPoint();
            this.spare = new CharsRefBuilder();
        }

        public GeoPoint next() throws IOException {
            BytesRef term = this.termsEnum.next();
            if (term == null) {
                return null;
            }
            this.spare.copyUTF8Bytes(term);
            int commaIndex = -1;
            for (int i = 0; i < this.spare.length(); ++i) {
                if (this.spare.charAt(i) != ',') continue;
                commaIndex = i;
                break;
            }
            if (commaIndex == -1) {
                assert (false);
                return this.next.reset(0.0, 0.0);
            }
            double lat = Double.parseDouble(new String(this.spare.chars(), 0, commaIndex));
            double lon = Double.parseDouble(new String(this.spare.chars(), commaIndex + 1, this.spare.length() - (commaIndex + 1)));
            return this.next.reset(lat, lon);
        }
    }
}

