/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.core.BinaryFieldMapper;
import org.elasticsearch.index.mapper.core.BooleanFieldMapper;
import org.elasticsearch.index.mapper.core.ByteFieldMapper;
import org.elasticsearch.index.mapper.core.CompletionFieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.IntegerFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.ShortFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TokenCountFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.mapper.internal.TimestampFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.internal.VersionFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;

public class DocumentMapperParser {
    private final Settings indexSettings;
    final MapperService mapperService;
    final AnalysisService analysisService;
    private static final ESLogger logger = Loggers.getLogger(DocumentMapperParser.class);
    private final SimilarityLookupService similarityLookupService;
    private final ScriptService scriptService;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Object typeParsersMutex = new Object();
    private final Version indexVersionCreated;
    private final ParseFieldMatcher parseFieldMatcher;
    private volatile ImmutableMap<String, Mapper.TypeParser> typeParsers;
    private volatile ImmutableMap<String, Mapper.TypeParser> rootTypeParsers;
    private volatile ImmutableMap<String, Mapper.TypeParser> additionalRootMappers;

    public DocumentMapperParser(Settings indexSettings, MapperService mapperService, AnalysisService analysisService, SimilarityLookupService similarityLookupService, ScriptService scriptService) {
        this.indexSettings = indexSettings;
        this.parseFieldMatcher = new ParseFieldMatcher(indexSettings);
        this.mapperService = mapperService;
        this.analysisService = analysisService;
        this.similarityLookupService = similarityLookupService;
        this.scriptService = scriptService;
        MapBuilder<String, ByteFieldMapper.TypeParser> typeParsersBuilder = new MapBuilder<String, ByteFieldMapper.TypeParser>().put("byte", new ByteFieldMapper.TypeParser()).put("short", (ByteFieldMapper.TypeParser)((Object)new ShortFieldMapper.TypeParser())).put("integer", (ByteFieldMapper.TypeParser)((Object)new IntegerFieldMapper.TypeParser())).put("long", (ByteFieldMapper.TypeParser)((Object)new LongFieldMapper.TypeParser())).put("float", (ByteFieldMapper.TypeParser)((Object)new FloatFieldMapper.TypeParser())).put("double", (ByteFieldMapper.TypeParser)((Object)new DoubleFieldMapper.TypeParser())).put("boolean", (ByteFieldMapper.TypeParser)((Object)new BooleanFieldMapper.TypeParser())).put("binary", (ByteFieldMapper.TypeParser)((Object)new BinaryFieldMapper.TypeParser())).put("date", (ByteFieldMapper.TypeParser)((Object)new DateFieldMapper.TypeParser())).put("ip", (ByteFieldMapper.TypeParser)((Object)new IpFieldMapper.TypeParser())).put("string", (ByteFieldMapper.TypeParser)((Object)new StringFieldMapper.TypeParser())).put("token_count", (ByteFieldMapper.TypeParser)((Object)new TokenCountFieldMapper.TypeParser())).put("object", (ByteFieldMapper.TypeParser)((Object)new ObjectMapper.TypeParser())).put("nested", (ByteFieldMapper.TypeParser)((Object)new ObjectMapper.TypeParser())).put("multi_field", (ByteFieldMapper.TypeParser)TypeParsers.multiFieldConverterTypeParser).put("completion", (ByteFieldMapper.TypeParser)((Object)new CompletionFieldMapper.TypeParser())).put("geo_point", (ByteFieldMapper.TypeParser)((Object)new GeoPointFieldMapper.TypeParser()));
        if (ShapesAvailability.JTS_AVAILABLE) {
            typeParsersBuilder.put("geo_shape", (ByteFieldMapper.TypeParser)((Object)new GeoShapeFieldMapper.TypeParser()));
        }
        this.typeParsers = typeParsersBuilder.immutableMap();
        this.rootTypeParsers = new MapBuilder<String, IndexFieldMapper.TypeParser>().put("_index", new IndexFieldMapper.TypeParser()).put("_source", (IndexFieldMapper.TypeParser)((Object)new SourceFieldMapper.TypeParser())).put("_type", (IndexFieldMapper.TypeParser)((Object)new TypeFieldMapper.TypeParser())).put("_all", (IndexFieldMapper.TypeParser)((Object)new AllFieldMapper.TypeParser())).put("_parent", (IndexFieldMapper.TypeParser)((Object)new ParentFieldMapper.TypeParser())).put("_routing", (IndexFieldMapper.TypeParser)((Object)new RoutingFieldMapper.TypeParser())).put("_timestamp", (IndexFieldMapper.TypeParser)((Object)new TimestampFieldMapper.TypeParser())).put("_ttl", (IndexFieldMapper.TypeParser)((Object)new TTLFieldMapper.TypeParser())).put("_uid", (IndexFieldMapper.TypeParser)((Object)new UidFieldMapper.TypeParser())).put("_version", (IndexFieldMapper.TypeParser)((Object)new VersionFieldMapper.TypeParser())).put("_id", (IndexFieldMapper.TypeParser)((Object)new IdFieldMapper.TypeParser())).put("_field_names", (IndexFieldMapper.TypeParser)((Object)new FieldNamesFieldMapper.TypeParser())).immutableMap();
        this.additionalRootMappers = ImmutableSortedMap.of();
        this.indexVersionCreated = Version.indexCreated(indexSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTypeParser(String type, Mapper.TypeParser typeParser) {
        Object object = this.typeParsersMutex;
        synchronized (object) {
            this.typeParsers = new MapBuilder<String, Mapper.TypeParser>((Map<String, Mapper.TypeParser>)this.typeParsers).put(type, typeParser).immutableMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRootTypeParser(String type, Mapper.TypeParser typeParser) {
        Object object = this.typeParsersMutex;
        synchronized (object) {
            this.rootTypeParsers = new MapBuilder<String, Mapper.TypeParser>((Map<String, Mapper.TypeParser>)this.rootTypeParsers).put(type, typeParser).immutableMap();
            this.additionalRootMappers = ImmutableSortedMap.naturalOrder().putAll(this.additionalRootMappers).put((Object)type, (Object)typeParser).build();
        }
    }

    public Mapper.TypeParser.ParserContext parserContext(String type) {
        return new Mapper.TypeParser.ParserContext(type, this.analysisService, this.similarityLookupService, this.mapperService, this.typeParsers, this.indexVersionCreated, this.parseFieldMatcher);
    }

    public DocumentMapper parse(String source) throws MapperParsingException {
        return this.parse(null, source);
    }

    public DocumentMapper parse(@Nullable String type, String source) throws MapperParsingException {
        return this.parse(type, source, null);
    }

    public DocumentMapper parse(@Nullable String type, String source, String defaultSource) throws MapperParsingException {
        Map<Object, Object> mapping = null;
        if (source != null) {
            Tuple<String, Map<String, Object>> t = this.extractMapping(type, source);
            type = t.v1();
            mapping = t.v2();
        }
        if (mapping == null) {
            mapping = Maps.newHashMap();
        }
        return this.parse(type, mapping, defaultSource);
    }

    public DocumentMapper parseCompressed(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        return this.parseCompressed(type, source, null);
    }

    public DocumentMapper parseCompressed(@Nullable String type, CompressedXContent source, String defaultSource) throws MapperParsingException {
        Map<Object, Object> mapping = null;
        if (source != null) {
            Map<String, Object> root = XContentHelper.convertToMap(source.compressedReference(), true).v2();
            Tuple<String, Map<String, Object>> t = this.extractMapping(type, root);
            type = t.v1();
            mapping = t.v2();
        }
        if (mapping == null) {
            mapping = Maps.newHashMap();
        }
        return this.parse(type, mapping, defaultSource);
    }

    private DocumentMapper parse(String type, Map<String, Object> mapping, String defaultSource) throws MapperParsingException {
        Tuple<String, Map<String, Object>> t;
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (defaultSource != null && (t = this.extractMapping("_default_", defaultSource)).v2() != null) {
            XContentHelper.mergeDefaults(mapping, t.v2());
        }
        Mapper.TypeParser.ParserContext parserContext = this.parserContext(type);
        DocumentMapper.Builder docBuilder = MapperBuilders.doc(this.indexSettings, (RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, mapping, parserContext), this.mapperService);
        for (Map.Entry<String, Object> entry : this.additionalRootMappers.entrySet()) {
            docBuilder.put((MetadataFieldMapper.Builder)((Mapper.TypeParser)entry.getValue()).parse((String)entry.getKey(), Collections.emptyMap(), parserContext));
        }
        Iterator<Map.Entry<String, Object>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            entry = iterator.next();
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if ("transform".equals(fieldName)) {
                if (fieldNode instanceof Map) {
                    this.parseTransform(docBuilder, (Map)fieldNode, parserContext.indexVersionCreated());
                } else if (fieldNode instanceof List) {
                    for (Object transformItem : (List)fieldNode) {
                        if (!(transformItem instanceof Map)) {
                            throw new MapperParsingException("Elements of transform list must be objects but one was:  " + fieldNode);
                        }
                        this.parseTransform(docBuilder, (Map)transformItem, parserContext.indexVersionCreated());
                    }
                } else {
                    throw new MapperParsingException("Transform must be an object or an array but was:  " + fieldNode);
                }
                iterator.remove();
                continue;
            }
            Mapper.TypeParser typeParser = (Mapper.TypeParser)this.rootTypeParsers.get((Object)fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            Map fieldNodeMap = (Map)fieldNode;
            docBuilder.put((MetadataFieldMapper.Builder)typeParser.parse(fieldName, fieldNodeMap, parserContext));
            fieldNodeMap.remove("type");
            DocumentMapperParser.checkNoRemainingFields(fieldName, fieldNodeMap, parserContext.indexVersionCreated());
        }
        ImmutableMap attributes = ImmutableMap.of();
        if (mapping.containsKey("_meta")) {
            attributes = ImmutableMap.copyOf((Map)((Map)mapping.remove("_meta")));
        }
        docBuilder.meta((ImmutableMap<String, Object>)attributes);
        DocumentMapperParser.checkNoRemainingFields(mapping, parserContext.indexVersionCreated(), "Root mapping definition has unsupported parameters: ");
        return docBuilder.build(this.mapperService, this);
    }

    public static void checkNoRemainingFields(String fieldName, Map<String, Object> fieldNodeMap, Version indexVersionCreated) {
        DocumentMapperParser.checkNoRemainingFields(fieldNodeMap, indexVersionCreated, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<String, Object> fieldNodeMap, Version indexVersionCreated, String message) {
        if (!fieldNodeMap.isEmpty()) {
            if (indexVersionCreated.onOrAfter(Version.V_2_0_0_beta1)) {
                throw new MapperParsingException(message + DocumentMapperParser.getRemainingFields(fieldNodeMap));
            }
            logger.debug(message + "{}", DocumentMapperParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<String, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (String key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }

    private void parseTransform(DocumentMapper.Builder docBuilder, Map<String, Object> transformConfig, Version indexVersionCreated) {
        Script script = Script.parse(transformConfig, true, this.parseFieldMatcher);
        if (script != null) {
            docBuilder.transform(this.scriptService, script);
        }
        DocumentMapperParser.checkNoRemainingFields(transformConfig, indexVersionCreated, "Transform config has unsupported parameters: ");
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map<String, Object> root;
        try (XContentParser parser = XContentFactory.xContent(source).createParser(source);){
            root = parser.mapOrdered();
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse mapping definition", e);
        }
        return this.extractMapping(type, root);
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, Map<String, Object> root) throws MapperParsingException {
        if (root.size() == 0) {
            throw new MapperParsingException("malformed mapping no root object found");
        }
        String rootName = root.keySet().iterator().next();
        Tuple<String, Map<String, Object>> mapping = type == null || type.equals(rootName) ? new Tuple<String, Map<String, Object>>(rootName, (Map)root.get(rootName)) : new Tuple<String, Map<String, Object>>(type, root);
        return mapping;
    }
}

