/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.flush;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.flush.SyncedFlushService;

public class ShardsSyncedFlushResult {
    private String failureReason;
    private Map<ShardRouting, SyncedFlushService.SyncedFlushResponse> shardResponses;
    private String syncId;
    private ShardId shardId;
    private int totalShards;

    public ShardsSyncedFlushResult() {
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardsSyncedFlushResult(ShardId shardId, int totalShards, String failureReason) {
        this.syncId = null;
        this.failureReason = failureReason;
        this.shardResponses = ImmutableMap.of();
        this.shardId = shardId;
        this.totalShards = totalShards;
    }

    public ShardsSyncedFlushResult(ShardId shardId, String syncId, int totalShards, Map<ShardRouting, SyncedFlushService.SyncedFlushResponse> shardResponses) {
        this.failureReason = null;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.shardResponses = builder.putAll(shardResponses).build();
        this.syncId = syncId;
        this.totalShards = totalShards;
        this.shardId = shardId;
    }

    public boolean failed() {
        return this.failureReason != null;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String syncId() {
        return this.syncId;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int successfulShards() {
        int i = 0;
        for (SyncedFlushService.SyncedFlushResponse result : this.shardResponses.values()) {
            if (!result.success()) continue;
            ++i;
        }
        return i;
    }

    public Map<ShardRouting, SyncedFlushService.SyncedFlushResponse> failedShards() {
        HashMap<ShardRouting, SyncedFlushService.SyncedFlushResponse> failures = new HashMap<ShardRouting, SyncedFlushService.SyncedFlushResponse>();
        for (Map.Entry<ShardRouting, SyncedFlushService.SyncedFlushResponse> result : this.shardResponses.entrySet()) {
            if (result.getValue().success()) continue;
            failures.put(result.getKey(), result.getValue());
        }
        return failures;
    }

    public Map<ShardRouting, SyncedFlushService.SyncedFlushResponse> shardResponses() {
        return this.shardResponses;
    }

    public ShardId shardId() {
        return this.shardId;
    }
}

