/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.script;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestPutIndexedScriptAction
extends BaseRestHandler {
    @Inject
    public RestPutIndexedScriptAction(Settings settings, RestController controller, Client client) {
        this(settings, controller, true, client);
    }

    protected RestPutIndexedScriptAction(Settings settings, RestController controller, boolean registerDefaultHandlers, Client client) {
        super(settings, controller, client);
        if (registerDefaultHandlers) {
            controller.registerHandler(RestRequest.Method.POST, "/_scripts/{lang}/{id}", this);
            controller.registerHandler(RestRequest.Method.PUT, "/_scripts/{lang}/{id}", this);
            controller.registerHandler(RestRequest.Method.PUT, "/_scripts/{lang}/{id}/_create", new CreateHandler(settings, controller, client));
            controller.registerHandler(RestRequest.Method.POST, "/_scripts/{lang}/{id}/_create", new CreateHandler(settings, controller, client));
        }
    }

    protected String getScriptLang(RestRequest request) {
        return request.param("lang");
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        PutIndexedScriptRequest putRequest = new PutIndexedScriptRequest(this.getScriptLang(request), request.param("id"));
        putRequest.version(request.paramAsLong("version", putRequest.version()));
        putRequest.versionType(VersionType.fromString(request.param("version_type"), putRequest.versionType()));
        putRequest.source(request.content());
        String sOpType = request.param("op_type");
        if (sOpType != null) {
            try {
                putRequest.opType(IndexRequest.OpType.fromString(sOpType));
            }
            catch (IllegalArgumentException eia) {
                try {
                    XContentBuilder builder = channel.newErrorBuilder();
                    channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, builder.startObject().field("error", eia.getMessage()).endObject()));
                    return;
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                    return;
                }
            }
        }
        client.putIndexedScript(putRequest, (ActionListener<PutIndexedScriptResponse>)new RestBuilderListener<PutIndexedScriptResponse>(channel){

            @Override
            public RestResponse buildResponse(PutIndexedScriptResponse response, XContentBuilder builder) throws Exception {
                builder.startObject().field(Fields._ID, response.getId()).field(Fields._VERSION, response.getVersion()).field(Fields.CREATED, response.isCreated());
                builder.endObject();
                RestStatus status = RestStatus.OK;
                if (response.isCreated()) {
                    status = RestStatus.CREATED;
                }
                return new BytesRestResponse(status, builder);
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString CREATED = new XContentBuilderString("created");

        Fields() {
        }
    }

    final class CreateHandler
    extends BaseRestHandler {
        protected CreateHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel, Client client) {
            request.params().put("op_type", "create");
            RestPutIndexedScriptAction.this.handleRequest(request, channel, client);
        }
    }
}

