/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.expression.FieldDataFunctionValues;
import org.elasticsearch.search.MultiValueMode;

class FieldDataValueSource
extends ValueSource {
    protected IndexFieldData<?> fieldData;
    protected MultiValueMode multiValueMode;

    protected FieldDataValueSource(IndexFieldData<?> d, MultiValueMode m) {
        Objects.requireNonNull(d);
        Objects.requireNonNull(m);
        this.fieldData = d;
        this.multiValueMode = m;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FieldDataValueSource that = (FieldDataValueSource)((Object)o);
        if (!this.fieldData.equals(that.fieldData)) {
            return false;
        }
        return this.multiValueMode == that.multiValueMode;
    }

    public int hashCode() {
        int result = this.fieldData.hashCode();
        result = 31 * result + this.multiValueMode.hashCode();
        return result;
    }

    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        Object leafData = this.fieldData.load(leaf);
        assert (leafData instanceof AtomicNumericFieldData);
        return new FieldDataFunctionValues(this, this.multiValueMode, (AtomicNumericFieldData)leafData);
    }

    public String description() {
        return "field(" + this.fieldData.getFieldNames().toString() + ")";
    }
}

