/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetric;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalScriptedMetric
extends InternalMetricsAggregation
implements ScriptedMetric {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("scripted_metric");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalScriptedMetric readResult(StreamInput in) throws IOException {
            InternalScriptedMetric result = new InternalScriptedMetric();
            result.readFrom(in);
            return result;
        }
    };
    private Script reduceScript;
    private Object aggregation;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    private InternalScriptedMetric() {
    }

    private InternalScriptedMetric(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
    }

    public InternalScriptedMetric(String name, Object aggregation, Script reduceScript, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        this(name, pipelineAggregators, metaData);
        this.aggregation = aggregation;
        this.reduceScript = reduceScript;
    }

    @Override
    public Object aggregation() {
        return this.aggregation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var5_8;
        ArrayList<Object> aggregationObjects = new ArrayList<Object>();
        for (InternalAggregation internalAggregation : aggregations) {
            InternalScriptedMetric mapReduceAggregation = (InternalScriptedMetric)internalAggregation;
            aggregationObjects.add(mapReduceAggregation.aggregation());
        }
        InternalScriptedMetric firstAggregation = (InternalScriptedMetric)aggregations.get(0);
        if (firstAggregation.reduceScript != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("_aggs", aggregationObjects);
            if (firstAggregation.reduceScript.getParams() != null) {
                vars.putAll(firstAggregation.reduceScript.getParams());
            }
            CompiledScript compiledScript = reduceContext.scriptService().compile(firstAggregation.reduceScript, ScriptContext.Standard.AGGS, reduceContext);
            ExecutableScript script = reduceContext.scriptService().executable(compiledScript, vars);
            Object object = script.run();
        } else {
            ArrayList<Object> arrayList = aggregationObjects;
        }
        return new InternalScriptedMetric(firstAggregation.getName(), var5_8, firstAggregation.reduceScript, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.aggregation;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.reduceScript = Script.readScript(in);
        }
        this.aggregation = in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        boolean hasScript = this.reduceScript != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.reduceScript.writeTo(out);
        }
        out.writeGenericValue(this.aggregation);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("value", this.aggregation);
    }
}

