/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.completion.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion.CompletionSuggestParser;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;

public class CompletionSuggester
extends Suggester<CompletionSuggestionContext> {
    private static final ScoreComparator scoreComparator = new ScoreComparator();

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, CompletionSuggestionContext suggestionContext, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        if (suggestionContext.fieldType() == null) {
            throw new ElasticsearchException("Field [" + suggestionContext.getField() + "] is not a completion suggest field", new Object[0]);
        }
        IndexReader indexReader = searcher.getIndexReader();
        CompletionSuggestion completionSuggestion = new CompletionSuggestion(name, suggestionContext.getSize());
        spare.copyUTF8Bytes(suggestionContext.getText());
        CompletionSuggestion.Entry completionSuggestEntry = new CompletionSuggestion.Entry(new StringText(spare.toString()), 0, spare.length());
        completionSuggestion.addTerm(completionSuggestEntry);
        String fieldName = suggestionContext.getField();
        HashMap results = Maps.newHashMapWithExpectedSize((int)(indexReader.leaves().size() * suggestionContext.getSize()));
        for (LeafReaderContext atomicReaderContext : indexReader.leaves()) {
            Completion090PostingsFormat.CompletionTerms lookupTerms;
            Lookup lookup;
            LeafReader atomicReader = atomicReaderContext.reader();
            Terms terms = atomicReader.fields().terms(fieldName);
            if (!(terms instanceof Completion090PostingsFormat.CompletionTerms) || (lookup = (lookupTerms = (Completion090PostingsFormat.CompletionTerms)terms).getLookup(suggestionContext.fieldType(), suggestionContext)) == null) continue;
            List lookupResults = lookup.lookup((CharSequence)spare.get(), false, suggestionContext.getSize());
            for (Lookup.LookupResult res : lookupResults) {
                String key = res.key.toString();
                float score = res.value;
                CompletionSuggestion.Entry.Option value = (CompletionSuggestion.Entry.Option)results.get(key);
                if (value == null) {
                    CompletionSuggestion.Entry.Option option = new CompletionSuggestion.Entry.Option((Text)new StringText(key), score, res.payload == null ? null : new BytesArray(res.payload));
                    results.put(key, option);
                    continue;
                }
                if (!(value.getScore() < score)) continue;
                value.setScore(score);
                value.setPayload(res.payload == null ? null : new BytesArray(res.payload));
            }
        }
        ArrayList options = new ArrayList(results.values());
        CollectionUtil.introSort(options, (Comparator)scoreComparator);
        int optionCount = Math.min(suggestionContext.getSize(), options.size());
        for (int i = 0; i < optionCount; ++i) {
            completionSuggestEntry.addOption((Suggest.Suggestion.Entry.Option)options.get(i));
        }
        return completionSuggestion;
    }

    @Override
    public SuggestContextParser getContextParser() {
        return new CompletionSuggestParser(this);
    }

    public static class ScoreComparator
    implements Comparator<CompletionSuggestion.Entry.Option> {
        @Override
        public int compare(CompletionSuggestion.Entry.Option o1, CompletionSuggestion.Entry.Option o2) {
            return Float.compare(o2.getScore(), o1.getScore());
        }
    }
}

