/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.component.plugins.Plugin;
import org.apache.log4j.component.plugins.PluginRegistry;
import org.apache.log4j.component.scheduler.Scheduler;
import org.apache.log4j.component.spi.ErrorItem;
import org.apache.log4j.component.spi.LoggerEventListener;
import org.apache.log4j.component.spi.LoggerRepositoryEventListener;
import org.apache.log4j.component.spi.LoggerRepositoryEx;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public final class LoggerRepositoryExImpl
implements LoggerRepositoryEx,
RendererSupport,
UnrecognizedElementHandler {
    private final LoggerRepository repo;
    private LoggerFactory loggerFactory;
    private final RendererSupport rendererSupport;
    private final ArrayList repositoryEventListeners = new ArrayList();
    private final Map loggerEventListeners = new HashMap();
    private String name;
    private PluginRegistry pluginRegistry;
    private final Map properties = new Hashtable();
    private Scheduler scheduler;
    private Map objectMap = new HashMap();
    private List errorList = new Vector();
    private boolean pristine = true;

    public LoggerRepositoryExImpl(LoggerRepository repository) {
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        this.repo = repository;
        this.rendererSupport = repository instanceof RendererSupport ? (RendererSupport)((Object)repository) : new RendererSupportImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoggerRepositoryEventListener(LoggerRepositoryEventListener listener) {
        ArrayList arrayList = this.repositoryEventListeners;
        synchronized (arrayList) {
            if (this.repositoryEventListeners.contains(listener)) {
                LogLog.warn((String)"Ignoring attempt to add a previously registered LoggerRepositoryEventListener.");
            } else {
                this.repositoryEventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoggerRepositoryEventListener(LoggerRepositoryEventListener listener) {
        ArrayList arrayList = this.repositoryEventListeners;
        synchronized (arrayList) {
            if (!this.repositoryEventListeners.contains(listener)) {
                LogLog.warn((String)"Ignoring attempt to remove a non-registered LoggerRepositoryEventListener.");
            } else {
                this.repositoryEventListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoggerEventListener(LoggerEventListener listener) {
        Map map = this.loggerEventListeners;
        synchronized (map) {
            if (this.loggerEventListeners.get(listener) != null) {
                LogLog.warn((String)"Ignoring attempt to add a previously registerd LoggerEventListener.");
            } else {
                HierarchyEventListenerProxy proxy = new HierarchyEventListenerProxy(listener);
                this.loggerEventListeners.put(listener, proxy);
                this.repo.addHierarchyEventListener(proxy);
            }
        }
    }

    public void addHierarchyEventListener(HierarchyEventListener listener) {
        this.repo.addHierarchyEventListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoggerEventListener(LoggerEventListener listener) {
        Map map = this.loggerEventListeners;
        synchronized (map) {
            HierarchyEventListenerProxy proxy = (HierarchyEventListenerProxy)this.loggerEventListeners.get(listener);
            if (proxy == null) {
                LogLog.warn((String)"Ignoring attempt to remove a non-registered LoggerEventListener.");
            } else {
                this.loggerEventListeners.remove(listener);
                proxy.disable();
            }
        }
    }

    public void emitNoAppenderWarning(Category cat) {
        this.repo.emitNoAppenderWarning(cat);
    }

    public Logger exists(String loggerName) {
        return this.repo.exists(loggerName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String repoName) {
        if (this.name == null) {
            this.name = repoName;
        } else if (!this.name.equals(repoName)) {
            throw new IllegalStateException("Repository [" + this.name + "] cannot be renamed as [" + repoName + "].");
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setThreshold(String levelStr) {
        this.repo.setThreshold(levelStr);
    }

    public void setThreshold(Level l) {
        this.repo.setThreshold(l);
    }

    public PluginRegistry getPluginRegistry() {
        if (this.pluginRegistry == null) {
            this.pluginRegistry = new PluginRegistry(this);
        }
        return this.pluginRegistry;
    }

    public void fireAddAppenderEvent(Category logger, Appender appender) {
        this.repo.fireAddAppenderEvent(logger, appender);
    }

    public void fireRemoveAppenderEvent(Category logger, Appender appender) {
        if (this.repo instanceof Hierarchy) {
            ((Hierarchy)this.repo).fireRemoveAppenderEvent(logger, appender);
        }
    }

    public void fireLevelChangedEvent(Logger logger) {
    }

    public void fireConfigurationChangedEvent() {
    }

    public Level getThreshold() {
        return this.repo.getThreshold();
    }

    public Logger getLogger(String loggerName) {
        return this.repo.getLogger(loggerName);
    }

    public Logger getLogger(String loggerName, LoggerFactory factory) {
        return this.repo.getLogger(loggerName, factory);
    }

    public Enumeration getCurrentLoggers() {
        return this.repo.getCurrentLoggers();
    }

    public List getErrorList() {
        return this.errorList;
    }

    public void addErrorItem(ErrorItem errorItem) {
        this.getErrorList().add(errorItem);
    }

    public Enumeration getCurrentCategories() {
        return this.repo.getCurrentCategories();
    }

    public RendererMap getRendererMap() {
        return this.rendererSupport.getRendererMap();
    }

    public Logger getRootLogger() {
        return this.repo.getRootLogger();
    }

    public boolean isDisabled(int level) {
        return this.repo.isDisabled(level);
    }

    public void resetConfiguration() {
        this.repo.resetConfiguration();
    }

    public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
        this.rendererSupport.setRenderer(renderedClass, renderer);
    }

    public boolean isPristine() {
        return this.pristine;
    }

    public void setPristine(boolean state) {
        this.pristine = state;
    }

    public void shutdown() {
        this.repo.shutdown();
    }

    public Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            this.scheduler.setDaemon(true);
            this.scheduler.start();
        }
        return this.scheduler;
    }

    public void putObject(String key, Object value) {
        this.objectMap.put(key, value);
    }

    public Object getObject(String key) {
        return this.objectMap.get(key);
    }

    public void setLoggerFactory(LoggerFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.loggerFactory = factory;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        Object instance;
        if ("plugin".equals(element.getNodeName()) && (instance = DOMConfigurator.parseElement(element, props, Plugin.class)) instanceof Plugin) {
            Plugin plugin = (Plugin)instance;
            String pluginName = DOMConfigurator.subst(element.getAttribute("name"), props);
            if (pluginName.length() > 0) {
                plugin.setName(pluginName);
            }
            this.getPluginRegistry().addPlugin(plugin);
            plugin.setLoggerRepository(this);
            LogLog.debug((String)"Pushing plugin on to the object stack.");
            plugin.activateOptions();
            return true;
        }
        return false;
    }

    private static final class HierarchyEventListenerProxy
    implements HierarchyEventListener {
        private LoggerEventListener listener;

        public HierarchyEventListenerProxy(LoggerEventListener l) {
            if (l == null) {
                throw new NullPointerException("l");
            }
            this.listener = l;
        }

        public void addAppenderEvent(Category cat, Appender appender) {
            if (this.isEnabled() && cat instanceof Logger) {
                this.listener.appenderAddedEvent((Logger)cat, appender);
            }
        }

        public void removeAppenderEvent(Category cat, Appender appender) {
            if (this.isEnabled() && cat instanceof Logger) {
                this.listener.appenderRemovedEvent((Logger)cat, appender);
            }
        }

        public synchronized void disable() {
            this.listener = null;
        }

        private synchronized boolean isEnabled() {
            return this.listener != null;
        }
    }

    private static final class RendererSupportImpl
    implements RendererSupport {
        private final RendererMap renderers = new RendererMap();

        public RendererMap getRendererMap() {
            return this.renderers;
        }

        public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
            this.renderers.put(renderedClass, renderer);
        }
    }
}

