/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.CachedModuleVersionResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryCacheStats;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

class InMemoryMetaDataCache {
    private final Map<ModuleVersionSelector, Set<String>> moduleVersionListing = new HashMap<ModuleVersionSelector, Set<String>>();
    private final Map<ModuleComponentIdentifier, CachedModuleVersionResult> metaData = new HashMap<ModuleComponentIdentifier, CachedModuleVersionResult>();
    private InMemoryCacheStats stats;

    InMemoryMetaDataCache(InMemoryCacheStats stats) {
        this.stats = stats;
    }

    public boolean supplyModuleVersions(ModuleVersionSelector requested, BuildableModuleVersionListingResolveResult result) {
        Set<String> versions = this.moduleVersionListing.get(requested);
        if (versions == null) {
            return false;
        }
        result.listed(versions);
        return true;
    }

    public void newModuleVersions(ModuleVersionSelector requested, BuildableModuleVersionListingResolveResult result) {
        if (result.getState() == BuildableModuleVersionListingResolveResult.State.Listed) {
            this.moduleVersionListing.put(requested, result.getVersions());
        }
    }

    boolean supplyMetaData(ModuleComponentIdentifier requested, BuildableModuleComponentMetaDataResolveResult result) {
        CachedModuleVersionResult fromCache = this.metaData.get(requested);
        if (fromCache == null) {
            return false;
        }
        fromCache.supply(result);
        ++this.stats.metadataServed;
        return true;
    }

    void newDependencyResult(ModuleComponentIdentifier requested, BuildableModuleComponentMetaDataResolveResult result) {
        CachedModuleVersionResult cachedResult = new CachedModuleVersionResult(result);
        if (cachedResult.isCacheable()) {
            this.metaData.put(requested, cachedResult);
        }
    }
}

