/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.ComponentReportRenderer;
import org.gradle.api.reporting.components.internal.TypeAwareBinaryRenderer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.test.TestSuiteContainer;

@Incubating
public class ComponentReport
extends DefaultTask {
    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TypeAwareBinaryRenderer getBinaryRenderer() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        ModelMap binaries;
        TestSuiteContainer testSuites;
        Project project = this.getProject();
        StyledTextOutput textOutput = this.getTextOutputFactory().create(ComponentReport.class);
        ComponentReportRenderer renderer = new ComponentReportRenderer(this.getFileResolver(), this.getBinaryRenderer());
        renderer.setOutput(textOutput);
        renderer.startProject(project);
        ArrayList<ComponentSpec> components = new ArrayList<ComponentSpec>();
        ComponentSpecContainer componentSpecs = (ComponentSpecContainer)this.getModelRegistry().find(ModelPath.path((String)"components"), ModelType.of(ComponentSpecContainer.class));
        if (componentSpecs != null) {
            components.addAll(componentSpecs.values());
        }
        if ((testSuites = (TestSuiteContainer)this.getModelRegistry().find(ModelPath.path((String)"testSuites"), ModelType.of(TestSuiteContainer.class))) != null) {
            components.addAll(testSuites.values());
        }
        renderer.renderComponents(components);
        ProjectSourceSet sourceSets = (ProjectSourceSet)this.getModelRegistry().find(ModelPath.path((String)"sources"), ModelType.of(ProjectSourceSet.class));
        if (sourceSets != null) {
            renderer.renderSourceSets((Collection<LanguageSourceSet>)sourceSets);
        }
        if ((binaries = (ModelMap)this.getModelRegistry().find(ModelPath.path((String)"binaries"), ModelTypes.modelMap(BinarySpec.class))) != null) {
            renderer.renderBinaries((Iterable<BinarySpec>)binaries);
        }
        renderer.completeProject(project);
        renderer.complete();
    }
}

