/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmClassGeneratorUtils {
    public static String signature(Constructor<?> constructor) {
        StringBuilder builder = new StringBuilder();
        AsmClassGeneratorUtils.visitFormalTypeParameters(builder, constructor.getTypeParameters());
        AsmClassGeneratorUtils.visitParameters(builder, constructor.getGenericParameterTypes());
        builder.append("V");
        AsmClassGeneratorUtils.visitExceptions(builder, constructor.getGenericExceptionTypes());
        return builder.toString();
    }

    public static String signature(Method method) {
        StringBuilder builder = new StringBuilder();
        AsmClassGeneratorUtils.visitFormalTypeParameters(builder, method.getTypeParameters());
        AsmClassGeneratorUtils.visitParameters(builder, method.getGenericParameterTypes());
        AsmClassGeneratorUtils.visitType(method.getGenericReturnType(), builder);
        AsmClassGeneratorUtils.visitExceptions(builder, method.getGenericExceptionTypes());
        return builder.toString();
    }

    private static void visitExceptions(StringBuilder builder, java.lang.reflect.Type[] exceptionTypes) {
        for (java.lang.reflect.Type exceptionType : exceptionTypes) {
            builder.append('^');
            AsmClassGeneratorUtils.visitType(exceptionType, builder);
        }
    }

    private static void visitParameters(StringBuilder builder, java.lang.reflect.Type[] parameterTypes) {
        builder.append('(');
        for (java.lang.reflect.Type paramType : parameterTypes) {
            AsmClassGeneratorUtils.visitType(paramType, builder);
        }
        builder.append(")");
    }

    private static void visitFormalTypeParameters(StringBuilder builder, TypeVariable<?>[] typeParameters) {
        if (typeParameters.length > 0) {
            builder.append('<');
            for (TypeVariable<?> typeVariable : typeParameters) {
                builder.append(typeVariable.getName());
                for (java.lang.reflect.Type bound : typeVariable.getBounds()) {
                    builder.append(':');
                    AsmClassGeneratorUtils.visitType(bound, builder);
                }
            }
            builder.append('>');
        }
    }

    private static void visitType(java.lang.reflect.Type type, StringBuilder builder) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            if (cl.isPrimitive()) {
                builder.append(Type.getType((Class)cl).getDescriptor());
            } else if (cl.isArray()) {
                builder.append(cl.getName().replace('.', '/'));
            } else {
                builder.append('L');
                builder.append(cl.getName().replace('.', '/'));
                builder.append(';');
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            AsmClassGeneratorUtils.visitNested(parameterizedType.getRawType(), builder);
            builder.append('<');
            for (java.lang.reflect.Type param : parameterizedType.getActualTypeArguments()) {
                AsmClassGeneratorUtils.visitType(param, builder);
            }
            builder.append(">;");
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    builder.append('*');
                    return;
                }
            } else {
                for (java.lang.reflect.Type upperType : wildcardType.getUpperBounds()) {
                    builder.append('+');
                    AsmClassGeneratorUtils.visitType(upperType, builder);
                }
            }
            for (java.lang.reflect.Type lowerType : wildcardType.getLowerBounds()) {
                builder.append('-');
                AsmClassGeneratorUtils.visitType(lowerType, builder);
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            builder.append('T');
            builder.append(typeVar.getName());
            builder.append(';');
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            builder.append('[');
            AsmClassGeneratorUtils.visitType(arrayType.getGenericComponentType(), builder);
        } else {
            throw new IllegalArgumentException(String.format("Cannot generate signature for %s.", type));
        }
    }

    private static void visitNested(java.lang.reflect.Type type, StringBuilder builder) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            if (cl.isPrimitive()) {
                builder.append(Type.getType((Class)cl).getDescriptor());
            } else {
                builder.append('L');
                builder.append(cl.getName().replace('.', '/'));
            }
        } else {
            AsmClassGeneratorUtils.visitType(type, builder);
        }
    }
}

