/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.MemoryInfo;
import org.gradle.util.Clock;

class DaemonStats {
    private final Clock totalTime;
    private final TimeProvider timeProvider;
    private final MemoryInfo memory;
    private int buildCount;
    private long currentBuildStart;
    private long allBuildsTime;
    private int currentPerformance;

    DaemonStats() {
        this(new Clock(), new TrueTimeProvider(), new MemoryInfo());
    }

    DaemonStats(Clock startTime, TimeProvider timeProvider, MemoryInfo memory) {
        this.totalTime = startTime;
        this.timeProvider = timeProvider;
        this.memory = memory;
    }

    void buildStarted() {
        ++this.buildCount;
        this.currentBuildStart = this.timeProvider.getCurrentTime();
    }

    void buildFinished() {
        this.allBuildsTime += this.timeProvider.getCurrentTime() - this.currentBuildStart;
        this.currentPerformance = DaemonStats.performance(this.allBuildsTime, this.memory);
    }

    private static int performance(long totalTime, MemoryInfo memoryInfo) {
        return 100 - NumberUtil.percentOf(memoryInfo.getCollectionTime(), totalTime);
    }

    int getCurrentPerformance() {
        return this.currentPerformance;
    }

    String getHealthInfo() {
        if (this.buildCount == 1) {
            return String.format("Starting build in new daemon [memory: %s]", NumberUtil.formatBytes(this.memory.getMaxMemory()));
        }
        return String.format("Starting %s build in daemon [uptime: %s, performance: %s%%, memory: %s%% of %s]", NumberUtil.ordinal(this.buildCount), this.totalTime.getTime(), this.currentPerformance, this.getMemoryUsed(), NumberUtil.formatBytes(this.memory.getMaxMemory()));
    }

    int getMemoryUsed() {
        return NumberUtil.percentOf(this.memory.getCommittedMemory(), this.memory.getMaxMemory());
    }
}

