/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCountLogger
implements TestListener {
    private final ProgressLoggerFactory factory;
    private ProgressLogger progressLogger;
    private final Logger logger;
    private long totalTests;
    private long failedTests;
    private long skippedTests;
    private boolean hadFailures;

    public TestCountLogger(ProgressLoggerFactory factory) {
        this(factory, LoggerFactory.getLogger(TestCountLogger.class));
    }

    TestCountLogger(ProgressLoggerFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    public void beforeTest(TestDescriptor testDescriptor) {
    }

    public void afterTest(TestDescriptor testDescriptor, TestResult result) {
        this.totalTests += result.getTestCount();
        this.failedTests += result.getFailedTestCount();
        this.skippedTests += result.getSkippedTestCount();
        this.progressLogger.progress(this.summary());
    }

    private String summary() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, this.totalTests, "test");
        builder.append(" completed");
        if (this.failedTests > 0L) {
            builder.append(", ");
            builder.append(this.failedTests);
            builder.append(" failed");
        }
        if (this.skippedTests > 0L) {
            builder.append(", ");
            builder.append(this.skippedTests);
            builder.append(" skipped");
        }
        return builder.toString();
    }

    private void append(StringBuilder dest, long count, String noun) {
        dest.append(count);
        dest.append(" ");
        dest.append(noun);
        if (count != 1L) {
            dest.append("s");
        }
    }

    public void beforeSuite(TestDescriptor suite) {
        if (suite.getParent() == null) {
            this.progressLogger = this.factory.newOperation(TestCountLogger.class);
            this.progressLogger.setDescription("Run tests");
            this.progressLogger.started();
        }
    }

    public void afterSuite(TestDescriptor suite, TestResult result) {
        if (suite.getParent() == null) {
            if (this.failedTests > 0L) {
                this.logger.error(TextUtil.getPlatformLineSeparator() + this.summary());
            }
            this.progressLogger.completed();
            if (result.getResultType() == TestResult.ResultType.FAILURE) {
                this.hadFailures = true;
            }
        }
    }

    public boolean hadFailures() {
        return this.hadFailures;
    }
}

