/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.rules.ModelMapCreators;
import org.gradle.api.internal.rules.NamedDomainObjectFactoryRegistry;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.BiAction;
import org.gradle.internal.BiActions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.model.ComponentBinaryRules;
import org.gradle.language.base.internal.model.ComponentRules;
import org.gradle.language.base.internal.registry.DefaultLanguageTransformContainer;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.Service;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.manage.schema.extract.FactoryBasedNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.binary.internal.BinarySpecFactory;
import org.gradle.platform.base.component.internal.ComponentSpecFactory;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultPlatformContainer;
import org.gradle.platform.base.internal.DefaultPlatformResolvers;
import org.gradle.platform.base.internal.PlatformResolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ComponentModelBasePlugin
implements Plugin<ProjectInternal> {
    private final ModelRegistry modelRegistry;
    private final ModelSchemaStore schemaStore;

    @Inject
    public ComponentModelBasePlugin(ModelRegistry modelRegistry, ModelSchemaStore schemaStore) {
        this.modelRegistry = modelRegistry;
        this.schemaStore = schemaStore;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LanguageBasePlugin.class);
        SimpleModelRuleDescriptor descriptor = new SimpleModelRuleDescriptor(ComponentModelBasePlugin.class.getSimpleName() + ".apply()");
        SpecializedMapSchema schema = (SpecializedMapSchema)this.schemaStore.getSchema(ModelType.of(ComponentSpecContainer.class));
        ModelPath components = ModelPath.path((String)"components");
        ModelCreator componentsCreator = ModelMapCreators.specialized((ModelPath)components, ComponentSpec.class, ComponentSpecContainer.class, schema.getImplementationType().asSubclass(ComponentSpecContainer.class), (ModelRuleDescriptor)descriptor);
        this.modelRegistry.create(componentsCreator);
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), ComponentRules.class);
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), ComponentBinaryRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Service
        ComponentSpecFactory componentSpecFactory() {
            return new ComponentSpecFactory("components");
        }

        @Service
        BinarySpecFactory binarySpecFactory() {
            return new BinarySpecFactory("binaries");
        }

        @Mutate
        void registerNodeInitializerExtractors(NodeInitializerRegistry nodeInitializerRegistry, ComponentSpecFactory componentSpecFactory, BinarySpecFactory binarySpecFactory, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory) {
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedNodeInitializerExtractionStrategy((InstanceFactory)componentSpecFactory, schemaStore, proxyFactory, BiActions.doNothing()));
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedNodeInitializerExtractionStrategy((InstanceFactory)binarySpecFactory, schemaStore, proxyFactory, (BiAction)new BiAction<BinarySpec, ModelSchema<? extends BinarySpec>>(){

                public void execute(BinarySpec binarySpec, ModelSchema<? extends BinarySpec> schema) {
                    BinarySpecInternal binarySpecInternal = (BinarySpecInternal)binarySpec;
                    if (!binarySpecInternal.isLegacyBinary()) {
                        binarySpecInternal.setPublicType(schema.getType().getConcreteClass());
                    }
                }
            }));
        }

        @Service
        LanguageTransformContainer languageTransforms() {
            return new DefaultLanguageTransformContainer();
        }

        @Mutate
        void closeComponentsForBinaries(ModelMap<Task> tasks, ComponentSpecContainer components) {
        }

        @Finalize
        void createSourceTransformTasks(TaskContainer tasks, ModelMap<BinarySpecInternal> binaries, LanguageTransformContainer languageTransforms, ServiceRegistry serviceRegistry) {
            Iterator i$ = languageTransforms.iterator();
            while (i$.hasNext()) {
                LanguageTransform language = (LanguageTransform)i$.next();
                for (BinarySpecInternal binary : binaries) {
                    if (binary.isLegacyBinary() || !language.applyToBinary(binary)) continue;
                    SourceTransformTaskConfig taskConfig = language.getTransformTask();
                    for (LanguageSourceSet languageSourceSet : binary.getInputs()) {
                        LanguageSourceSetInternal sourceSet = (LanguageSourceSetInternal)languageSourceSet;
                        if (!language.getSourceSetType().isInstance(sourceSet) || !sourceSet.getMayHaveSources()) continue;
                        String taskName = taskConfig.getTaskPrefix() + StringUtils.capitalize((String)binary.getName()) + StringUtils.capitalize((String)sourceSet.getFullName());
                        Task task = tasks.create(taskName, taskConfig.getTaskType());
                        taskConfig.configureTask(task, binary, sourceSet, serviceRegistry);
                        task.dependsOn(new Object[]{sourceSet});
                        binary.getTasks().add(task);
                    }
                }
            }
        }

        @Model
        PlatformContainer platforms(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformContainer)instantiator.newInstance(DefaultPlatformContainer.class, new Object[]{instantiator});
        }

        @Service
        PlatformResolvers platformResolver(PlatformContainer platforms) {
            return new DefaultPlatformResolvers(platforms);
        }

        @Mutate
        void registerPlatformExtension(ExtensionContainer extensions, PlatformContainer platforms) {
            extensions.add("platforms", (Object)platforms);
        }

        @Mutate
        void registerLegacyBinaryFactories(BinaryContainer binaries, BinarySpecFactory binarySpecFactory) {
            binarySpecFactory.copyDomainObjectFactoriesInto((NamedDomainObjectFactoryRegistry<BinarySpec>)binaries);
        }

        @Defaults
        void collectBinaries(BinaryContainer binaries, ComponentSpecContainer componentSpecs) {
            for (ComponentSpec componentSpec : componentSpecs.values()) {
                for (BinarySpec binary : componentSpec.getBinaries().values()) {
                    binaries.add(binary);
                }
            }
        }

        @Validate
        void validateComponentSpecInternalViews(ComponentSpecFactory instanceFactory) {
            instanceFactory.validateRegistrations();
        }

        @Validate
        void validateBinarySpecInternalViews(BinarySpecFactory instanceFactory) {
            instanceFactory.validateRegistrations();
        }

        @Defaults
        void addSourceSetsOwnedByBinariesToTheirInputs(ModelMap<BinarySpec> binarySpecs) {
            binarySpecs.withType(BinarySpecInternal.class).afterEach((Action)new Action<BinarySpecInternal>(){

                public void execute(BinarySpecInternal binary) {
                    if (binary.isLegacyBinary()) {
                        return;
                    }
                    binary.getInputs().addAll(binary.getSources().values());
                }
            });
        }
    }
}

