/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.hash.HashUtil;

public abstract class AbstractUriScriptSource
implements ScriptSource {
    private String className;

    public String getClassName() {
        if (this.className == null) {
            URI sourceUri = this.getResource().getURI();
            String name = StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)sourceUri.toString(), (String)"/"), (String)".");
            StringBuilder className = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isJavaIdentifierPart(ch)) {
                    className.append(ch);
                    continue;
                }
                className.append('_');
            }
            if (!Character.isJavaIdentifierStart(className.charAt(0))) {
                className.insert(0, '_');
            }
            className.setLength(Math.min(className.length(), 30));
            className.append('_');
            String path = sourceUri.toString();
            className.append(HashUtil.createCompactMD5((String)path));
            this.className = className.toString();
        }
        return this.className;
    }
}

