/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.language.base.internal.tasks.apigen.ApiStubGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubbedJar
extends DefaultTask {
    private Collection<String> exportedPackages;
    private File runtimeClassesDir;
    private File destinationDir;
    private String archiveName;
    private File apiClassesDir;

    @Input
    public Collection<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public void setExportedPackages(Collection<String> exportedPackages) {
        this.exportedPackages = exportedPackages;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public File getApiClassesDir() {
        return this.apiClassesDir;
    }

    public void setApiClassesDir(File stubbedClassesDir) {
        this.apiClassesDir = stubbedClassesDir;
    }

    @InputDirectory
    @SkipWhenEmpty
    public File getRuntimeClassesDir() {
        return this.runtimeClassesDir;
    }

    public void setRuntimeClassesDir(File runtimeClassesDir) {
        this.runtimeClassesDir = runtimeClassesDir;
    }

    @Input
    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    @TaskAction
    void createStubs(IncrementalTaskInputs inputs) throws Exception {
        File archivePath = new File(this.destinationDir, this.archiveName);
        if (!inputs.isIncremental()) {
            FileUtils.deleteQuietly((File)archivePath);
            FileUtils.deleteDirectory((File)this.apiClassesDir);
        }
        this.destinationDir.mkdirs();
        this.apiClassesDir.mkdirs();
        final ApiStubGenerator stubGenerator = new ApiStubGenerator((List)ImmutableList.copyOf(this.getExportedPackages()));
        final AtomicBoolean updated = new AtomicBoolean();
        final HashMap convertedFiles = Maps.newHashMap();
        inputs.outOfDate((Action)new ErroringAction<InputFileDetails>(){

            protected void doExecute(InputFileDetails inputFileDetails) throws Exception {
                updated.set(true);
                File file = inputFileDetails.getFile();
                File stubFile = StubbedJar.this.getStubFileFor(file);
                if (!StubbedJar.isClass(file) || !stubGenerator.belongsToAPI((InputStream)new FileInputStream(file))) {
                    StubbedJar.this.deleteStub(stubFile);
                    return;
                }
                final byte[] bytes = stubGenerator.convertToApi((InputStream)new FileInputStream(file));
                convertedFiles.put(file, bytes);
                stubFile.getParentFile().mkdirs();
                IoActions.withResource((Closeable)new FileOutputStream(stubFile), (Action)new ErroringAction<FileOutputStream>(){

                    protected void doExecute(FileOutputStream fos) throws Exception {
                        fos.write(bytes);
                    }
                });
            }
        });
        inputs.removed((Action)new ErroringAction<InputFileDetails>(){

            protected void doExecute(InputFileDetails input) throws Exception {
                updated.set(true);
                StubbedJar.this.deleteStub(StubbedJar.this.getStubFileFor(input.getFile()));
            }
        });
        if (updated.get()) {
            IoActions.withResource((Closeable)new JarOutputStream(new BufferedOutputStream(new FileOutputStream(archivePath), 65536)), (Action)new ErroringAction<JarOutputStream>(){
                private final SortedMap<String, File> sortedFiles = Maps.newTreeMap();

                private void writeEntries(JarOutputStream jos) throws Exception {
                    for (Map.Entry<String, File> entry : this.sortedFiles.entrySet()) {
                        JarEntry ze = new JarEntry(entry.getKey());
                        ze.setTime(0L);
                        File stubFile = entry.getValue();
                        byte[] stub = (byte[])convertedFiles.get(stubFile);
                        if (stub == null) {
                            stub = FileUtils.readFileToByteArray((File)stubFile);
                        }
                        ze.setSize(stub.length);
                        jos.putNextEntry(ze);
                        jos.write(stub);
                        jos.closeEntry();
                    }
                }

                private void collectFiles(String relativePath, File f) throws Exception {
                    String path;
                    String string = path = "".equals(relativePath) ? f.getName() : relativePath + "/" + f.getName();
                    if (f.isFile()) {
                        this.sortedFiles.put(path, f);
                    } else if (f.isDirectory()) {
                        for (File file : f.listFiles()) {
                            String root = relativePath == null ? "" : path;
                            this.collectFiles(root, file);
                        }
                    }
                }

                protected void doExecute(JarOutputStream jos) throws Exception {
                    this.writeManifest(jos);
                    this.collectFiles(null, StubbedJar.this.apiClassesDir);
                    this.writeEntries(jos);
                    jos.close();
                }

                private void writeManifest(JarOutputStream jos) throws IOException {
                    JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
                    je.setTime(0L);
                    jos.putNextEntry(je);
                    jos.write("Manifest-Version: 1.0\n".getBytes());
                    jos.closeEntry();
                }
            });
        }
    }

    private void deleteStub(File stubFile) {
        if (stubFile.exists()) {
            FileUtils.deleteQuietly((File)stubFile);
        }
    }

    private File getStubFileFor(File file) {
        StringBuilder sb = new StringBuilder(file.getName());
        File cur = file.getParentFile();
        while (!cur.equals(this.runtimeClassesDir)) {
            sb.insert(0, cur.getName() + File.separator);
            cur = cur.getParentFile();
        }
        return new File(this.apiClassesDir, sb.toString());
    }

    private static boolean isClass(File file) {
        return file.getName().endsWith(".class");
    }
}

