/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.play.JvmClasses;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.PublicAssets;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.platform.PlayPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlayApplicationBinarySpec
extends BaseBinarySpec
implements PlayApplicationBinarySpecInternal {
    private final JvmClasses classesDir = new DefaultJvmClasses();
    private final PublicAssets assets = new DefaultPublicAssets();
    private Map<LanguageSourceSet, ScalaLanguageSourceSet> generatedScala = Maps.newHashMap();
    private Map<LanguageSourceSet, JavaScriptSourceSet> generatedJavaScript = Maps.newHashMap();
    private PlayPlatform platform;
    private PlayToolChainInternal toolChain;
    private File jarFile;
    private File assetsJarFile;
    private FileCollection classpath;
    private PlayApplicationSpec application;

    protected String getTypeName() {
        return "Play Application Jar";
    }

    @Override
    public PlayApplicationSpec getApplication() {
        return this.application;
    }

    @Override
    public void setApplication(PlayApplicationSpec application) {
        this.application = application;
    }

    @Override
    public PlayPlatform getTargetPlatform() {
        return this.platform;
    }

    @Override
    public PlayToolChainInternal getToolChain() {
        return this.toolChain;
    }

    @Override
    public File getJarFile() {
        return this.jarFile;
    }

    @Override
    public void setTargetPlatform(PlayPlatform platform) {
        this.platform = platform;
    }

    @Override
    public void setToolChain(PlayToolChainInternal toolChain) {
        this.toolChain = toolChain;
    }

    @Override
    public void setJarFile(File file) {
        this.jarFile = file;
    }

    @Override
    public File getAssetsJarFile() {
        return this.assetsJarFile;
    }

    @Override
    public void setAssetsJarFile(File assetsJarFile) {
        this.assetsJarFile = assetsJarFile;
    }

    @Override
    public JvmClasses getClasses() {
        return this.classesDir;
    }

    @Override
    public PublicAssets getAssets() {
        return this.assets;
    }

    @Override
    public Map<LanguageSourceSet, ScalaLanguageSourceSet> getGeneratedScala() {
        return this.generatedScala;
    }

    @Override
    public Map<LanguageSourceSet, JavaScriptSourceSet> getGeneratedJavaScript() {
        return this.generatedJavaScript;
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public BinaryBuildAbility getBinaryBuildAbility() {
        return new ToolSearchBuildAbility((ToolSearchResult)this.getToolChain().select(this.getTargetPlatform()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPublicAssets
    extends AbstractBuildableModelElement
    implements PublicAssets {
        private Set<File> resourceDirs = Sets.newLinkedHashSet();

        private DefaultPublicAssets() {
        }

        @Override
        public Set<File> getAssetDirs() {
            return this.resourceDirs;
        }

        @Override
        public void addAssetDir(File assetDir) {
            this.resourceDirs.add(assetDir);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultJvmClasses
    extends AbstractBuildableModelElement
    implements JvmClasses {
        private Set<File> resourceDirs = Sets.newLinkedHashSet();
        private File classesDir;

        private DefaultJvmClasses() {
        }

        @Override
        public File getClassesDir() {
            return this.classesDir;
        }

        @Override
        public void setClassesDir(File classesDir) {
            this.classesDir = classesDir;
        }

        @Override
        public Set<File> getResourceDirs() {
            return this.resourceDirs;
        }

        @Override
        public void addResourceDir(File resourceDir) {
            this.resourceDirs.add(resourceDir);
        }
    }
}

