/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableByteBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableByteBag;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedByteCollection;
import com.gs.collections.impl.factory.primitive.ByteBags;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedByteBag
extends AbstractSynchronizedByteCollection
implements MutableByteBag {
    private static final long serialVersionUID = 1L;

    SynchronizedByteBag(MutableByteBag bag) {
        super((MutableByteCollection)bag);
    }

    SynchronizedByteBag(MutableByteBag bag, Object newLock) {
        super((MutableByteCollection)bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableByteBag getMutableByteBag() {
        return (MutableByteBag)this.getByteCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag with(byte element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag without(byte element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag withAll(ByteIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag withoutAll(ByteIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(byte item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(byte item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(byte item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(ByteIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteBag select(BytePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteBag reject(BytePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyByteIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }
    }

    public MutableByteBag asUnmodifiable() {
        return new UnmodifiableByteBag(this);
    }

    public MutableByteBag asSynchronized() {
        return this;
    }

    public ImmutableByteBag toImmutable() {
        return ByteBags.immutable.withAll((ByteIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableByteBag().injectInto(injectedValue, function);
        }
    }
}

