/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.block.procedure.CaseProcedure;
import com.gs.collections.impl.block.procedure.IfProcedure;
import java.io.IOException;
import java.io.PrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Procedures {
    private Procedures() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> Procedure<T> cast(Procedure<T> procedure) {
        return procedure;
    }

    public static <T> Procedure<T> println(PrintStream stream) {
        return new PrintlnProcedure(stream);
    }

    public static <T> Procedure<T> append(Appendable appendable) {
        return new AppendProcedure(appendable);
    }

    @Deprecated
    public static <T> Procedure<T> fromProcedureWithInt(ObjectIntProcedure<? super T> objectIntProcedure) {
        return Procedures.fromObjectIntProcedure(objectIntProcedure);
    }

    public static <T> Procedure<T> fromObjectIntProcedure(ObjectIntProcedure<? super T> objectIntProcedure) {
        return new ObjectIntProcedureAdapter(objectIntProcedure);
    }

    public static <T> Procedure<T> ifTrue(Predicate<? super T> predicate, Procedure<? super T> block) {
        return new IfProcedure<T>(predicate, block);
    }

    public static <T> Procedure<T> ifElse(Predicate<? super T> predicate, Procedure<? super T> trueProcedure, Procedure<? super T> falseProcedure) {
        return new IfProcedure<T>(predicate, trueProcedure, falseProcedure);
    }

    public static <T> CaseProcedure<T> caseDefault(Procedure<? super T> defaultProcedure) {
        return new CaseProcedure<T>(defaultProcedure);
    }

    public static <T> CaseProcedure<T> caseDefault(Procedure<? super T> defaultProcedure, Predicate<? super T> predicate, Procedure<? super T> procedure) {
        return Procedures.caseDefault(defaultProcedure).addCase(predicate, procedure);
    }

    public static <T> Procedure<T> synchronizedEach(Procedure<T> procedure) {
        return new SynchronizedProcedure(procedure);
    }

    public static <T, P> Procedure<T> bind(Procedure2<? super T, ? super P> procedure, P parameter) {
        return new BindProcedure(procedure, parameter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindProcedure<T, P>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Procedure2<? super T, ? super P> procedure;
        private final P parameter;

        private BindProcedure(Procedure2<? super T, ? super P> procedure, P parameter) {
            this.procedure = procedure;
            this.parameter = parameter;
        }

        public void value(T each) {
            this.procedure.value(each, this.parameter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SynchronizedProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Procedure<T> procedure;

        private SynchronizedProcedure(Procedure<T> procedure) {
            this.procedure = procedure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void value(T each) {
            if (each == null) {
                this.procedure.value(null);
            } else {
                T t = each;
                synchronized (t) {
                    this.procedure.value(each);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectIntProcedureAdapter<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 2L;
        private int count;
        private final ObjectIntProcedure<? super T> objectIntProcedure;

        private ObjectIntProcedureAdapter(ObjectIntProcedure<? super T> objectIntProcedure) {
            this.objectIntProcedure = objectIntProcedure;
        }

        public void value(T each) {
            this.objectIntProcedure.value(each, this.count);
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AppendProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Appendable appendable;

        private AppendProcedure(Appendable appendable) {
            this.appendable = appendable;
        }

        public void value(T each) {
            try {
                this.appendable.append(String.valueOf(each));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.appendable.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrintlnProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final PrintStream stream;

        private PrintlnProcedure(PrintStream stream) {
            this.stream = stream;
        }

        public void value(T each) {
            this.stream.println(each);
        }
    }
}

