/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.set;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterableImpl;
import com.gs.collections.impl.lazy.parallel.Batch;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ParallelCollectIterable<T, V>
extends AbstractParallelIterableImpl<V, Batch<V>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> parallelIterable;
    private final Function<? super T, ? extends V> function;

    public ParallelCollectIterable(AbstractParallelIterable<T, ? extends Batch<T>> parallelIterable, Function<? super T, ? extends V> function) {
        this.parallelIterable = parallelIterable;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public LazyIterable<Batch<V>> split() {
        return this.parallelIterable.split().collect(new Function<Batch<T>, Batch<V>>(){

            public Batch<V> valueOf(Batch<T> eachBatch) {
                return eachBatch.collect(ParallelCollectIterable.this.function);
            }
        });
    }

    public void forEach(Procedure<? super V> procedure) {
        this.parallelIterable.forEach(Functions.bind(procedure, this.function));
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.allSatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public V detect(Predicate<? super V> predicate) {
        Object resultItem = this.parallelIterable.detect(Predicates.attributePredicate(this.function, predicate));
        return (V)(resultItem == null ? null : this.function.valueOf(resultItem));
    }
}

