/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectDoubleToObjectIterable<V>
extends AbstractLazyIterable<V> {
    private final DoubleIterable iterable;
    private final DoubleToObjectFunction<? extends V> function;

    public CollectDoubleToObjectIterable(DoubleIterable iterable, DoubleToObjectFunction<? extends V> function) {
        this.iterable = iterable;
        this.function = function;
    }

    public void forEach(final Procedure<? super V> procedure) {
        this.iterable.forEach(new DoubleProcedure(){

            public void value(double each) {
                procedure.value(CollectDoubleToObjectIterable.this.function.valueOf(each));
            }
        });
    }

    public void forEachWithIndex(final ObjectIntProcedure<? super V> objectIntProcedure) {
        this.iterable.forEach(new DoubleProcedure(){
            private int index;

            public void value(double each) {
                objectIntProcedure.value(CollectDoubleToObjectIterable.this.function.valueOf(each), this.index++);
            }
        });
    }

    public <P> void forEachWith(final Procedure2<? super V, ? super P> procedure, final P parameter) {
        this.iterable.forEach(new DoubleProcedure(){

            public void value(double each) {
                procedure.value(CollectDoubleToObjectIterable.this.function.valueOf(each), parameter);
            }
        });
    }

    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private final DoubleIterator iterator;
            {
                this.iterator = CollectDoubleToObjectIterable.this.iterable.doubleIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                return CollectDoubleToObjectIterable.this.function.valueOf(this.iterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }
        };
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }
}

