/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.CharToDoubleFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.CharDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableCharDoubleMap;
import com.gs.collections.api.map.primitive.MutableCharDoubleMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.CharDoublePair;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharDoubleMaps;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharDoubleMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableCharDoubleMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedCharSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharDoubleHashMap
implements MutableCharDoubleMap,
Externalizable {
    static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private char[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public CharDoubleHashMap() {
        this.allocateTable(16);
    }

    public CharDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public CharDoubleHashMap(CharDoubleMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1) {
        return new CharDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1, char key2, double value2) {
        return new CharDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1, char key2, double value2, char key3, double value3) {
        return new CharDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1, char key2, double value2, char key3, double value3, char key4, double value4) {
        return new CharDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharDoubleMap)) {
            return false;
        }
        CharDoubleMap other = (CharDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey('\u0000') || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow('\u0000')) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey('\u0001') || Double.compare(this.sentinelValues.oneValue, other.getOrThrow('\u0001')) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf('\u0000')).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf('\u0001')).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharDoubleHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                char key = this.keys[i];
                if (!CharDoubleHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public double[] toArray() {
        double[] array = new double[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(double value) {
        return this.containsValue(value);
    }

    public boolean containsAll(double ... source) {
        for (double each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.allSatisfy(new DoublePredicate(){

            public boolean accept(double value) {
                return CharDoubleHashMap.this.contains(value);
            }
        });
    }

    public void forEach(DoubleProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public double detectIfNone(DoublePredicate predicate, double value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, 0.0);
    }

    public void put(char key, double value) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(CharDoubleMap map) {
        map.forEachKeyValue(new CharDoubleProcedure(){

            public void value(char key, double value) {
                CharDoubleHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(char key) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(char key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(char key, double value) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            double oldValue = this.values[index];
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(char key, double value) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPut(char key, DoubleFunction0 function) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> double getIfAbsentPutWith(char key, DoubleFunction<? super P> function, P parameter) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPutWithKey(char key, CharToDoubleFunction function) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double addToValue(char key, double toBeAdded) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(char key, double value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(double value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = 0.0;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(double value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = 0.0;
        } else {
            this.sentinelValues = null;
        }
    }

    public double updateValue(char key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public CharDoubleHashMap withKeyValue(char key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public CharDoubleHashMap withKeysValues(char key1, double value1, char key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharDoubleHashMap withKeysValues(char key1, double value1, char key2, double value2, char key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharDoubleHashMap withKeysValues(char key1, double value1, char key2, double value2, char key3, double value3, char key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public CharDoubleHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public CharDoubleHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(new CharProcedure(){

            public void value(char key) {
                CharDoubleHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableCharDoubleMap asUnmodifiable() {
        return new UnmodifiableCharDoubleMap(this);
    }

    public MutableCharDoubleMap asSynchronized() {
        return new SynchronizedCharDoubleMap(this);
    }

    public ImmutableCharDoubleMap toImmutable() {
        return CharDoubleMaps.immutable.ofAll((CharDoubleMap)this);
    }

    public double get(char key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(char key, double ifAbsent) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public double getOrThrow(char key) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(double value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || Double.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (char key : this.keys) {
            if (!CharDoubleHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(CharDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyCharIterable keysView() {
        return new KeysView();
    }

    public RichIterable<CharDoublePair> keyValuesView() {
        return new KeyValuesView();
    }

    public CharDoubleHashMap select(CharDoublePredicate predicate) {
        CharDoubleHashMap result = new CharDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public CharDoubleHashMap reject(CharDoublePredicate predicate) {
        CharDoubleHashMap result = new CharDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double max = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double min = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(char element) {
        int index = this.spread(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == '\u0001') {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == '\u0000') break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(char element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharDoubleHashMap.isEmptyKey(key) && !CharDoubleHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ char[] access$802(CharDoubleHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ double[] access$1002(CharDoubleHashMap x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<CharDoublePair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super CharDoublePair> procedure) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharDoubleHashMap.this.sentinelValues.zeroValue));
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharDoubleHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharDoubleHashMap.this.keys[i], CharDoubleHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super CharDoublePair> objectIntProcedure) {
            int index = 0;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0000', CharDoubleHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0001', CharDoubleHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(CharDoubleHashMap.this.keys[i], CharDoubleHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super CharDoublePair, ? super P> procedure, P parameter) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharDoubleHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharDoubleHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharDoubleHashMap.this.keys[i], CharDoubleHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<CharDoublePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<CharDoublePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharDoublePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharDoubleHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', CharDoubleHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharDoubleHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', CharDoubleHashMap.this.sentinelValues.oneValue);
                    }
                }
                char[] keys = CharDoubleHashMap.this.keys;
                while (!CharDoubleHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                CharDoublePair result = PrimitiveTuples.pair(keys[this.position], CharDoubleHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharDoubleHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableDoubleCollection {
        private ValuesCollection() {
        }

        public void clear() {
            CharDoubleHashMap.this.clear();
        }

        public MutableDoubleCollection select(DoublePredicate predicate) {
            return CharDoubleHashMap.this.select(predicate);
        }

        public MutableDoubleCollection reject(DoublePredicate predicate) {
            return CharDoubleHashMap.this.reject(predicate);
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            return CharDoubleHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
            return CharDoubleHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            return CharDoubleHashMap.this.injectInto(injectedValue, function);
        }

        public double sum() {
            return CharDoubleHashMap.this.sum();
        }

        public double max() {
            return CharDoubleHashMap.this.max();
        }

        public double maxIfEmpty(double defaultValue) {
            return CharDoubleHashMap.this.maxIfEmpty(defaultValue);
        }

        public double min() {
            return CharDoubleHashMap.this.min();
        }

        public double minIfEmpty(double defaultValue) {
            return CharDoubleHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return CharDoubleHashMap.this.average();
        }

        public double median() {
            return CharDoubleHashMap.this.median();
        }

        public double[] toSortedArray() {
            return CharDoubleHashMap.this.toSortedArray();
        }

        public MutableDoubleList toSortedList() {
            return CharDoubleHashMap.this.toSortedList();
        }

        public MutableDoubleCollection with(double element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection without(double element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection asUnmodifiable() {
            return UnmodifiableDoubleCollection.of(this);
        }

        public MutableDoubleCollection asSynchronized() {
            return SynchronizedDoubleCollection.of(this);
        }

        public ImmutableDoubleCollection toImmutable() {
            return DoubleLists.immutable.withAll((DoubleIterable)this);
        }

        public boolean contains(double value) {
            return CharDoubleHashMap.this.containsValue(value);
        }

        public boolean containsAll(double ... source) {
            return CharDoubleHashMap.this.containsAll(source);
        }

        public boolean containsAll(DoubleIterable source) {
            return CharDoubleHashMap.this.containsAll(source);
        }

        public MutableDoubleList toList() {
            return CharDoubleHashMap.this.toList();
        }

        public MutableDoubleSet toSet() {
            return CharDoubleHashMap.this.toSet();
        }

        public MutableDoubleBag toBag() {
            return CharDoubleHashMap.this.toBag();
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public boolean isEmpty() {
            return CharDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharDoubleHashMap.this.sentinelValues != null) {
                    if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(CharDoubleHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(CharDoubleHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                    char key = CharDoubleHashMap.this.keys[i];
                    if (!CharDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(CharDoubleHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return CharDoubleHashMap.this.doubleIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            CharDoubleHashMap.this.forEach(procedure);
        }

        public int count(DoublePredicate predicate) {
            return CharDoubleHashMap.this.count(predicate);
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            return CharDoubleHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            return CharDoubleHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            return CharDoubleHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(double item) {
            int oldSize = CharDoubleHashMap.this.size();
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && Double.compare(item, CharDoubleHashMap.this.sentinelValues.zeroValue) == 0) {
                    CharDoubleHashMap.this.removeKey('\u0000');
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && Double.compare(item, CharDoubleHashMap.this.sentinelValues.oneValue) == 0) {
                    CharDoubleHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i]) || Double.compare(item, CharDoubleHashMap.this.values[i]) != 0) continue;
                CharDoubleHashMap.this.removeKey(CharDoubleHashMap.this.keys[i]);
            }
            return oldSize != CharDoubleHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = CharDoubleHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != CharDoubleHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = CharDoubleHashMap.this.size();
            for (double item : source) {
                this.remove(item);
            }
            return oldSize != CharDoubleHashMap.this.size();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            CharDoubleHashMap retained = CharDoubleHashMap.this.select(new CharDoublePredicate((DoubleSet)sourceSet){
                final /* synthetic */ DoubleSet val$sourceSet;
                {
                    this.val$sourceSet = doubleSet;
                }

                public boolean accept(char key, double value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                CharDoubleHashMap.access$802(CharDoubleHashMap.this, retained.keys);
                CharDoubleHashMap.access$1002(CharDoubleHashMap.this, retained.values);
                CharDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                CharDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(double ... source) {
            return this.retainAll((DoubleIterable)DoubleHashSet.newSetWith(source));
        }

        public int size() {
            return CharDoubleHashMap.this.size();
        }

        public double[] toArray() {
            return CharDoubleHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableCharSet {
        private KeySet() {
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(CharPredicate predicate) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(CharPredicate predicate) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return false;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(char key) {
            int oldSize = CharDoubleHashMap.this.size();
            CharDoubleHashMap.this.removeKey(key);
            return oldSize != CharDoubleHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = CharDoubleHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                CharDoubleHashMap.this.removeKey(iterator.next());
            }
            return oldSize != CharDoubleHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = CharDoubleHashMap.this.size();
            for (char item : source) {
                CharDoubleHashMap.this.removeKey(item);
            }
            return oldSize != CharDoubleHashMap.this.size();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharDoubleHashMap retained = CharDoubleHashMap.this.select(new CharDoublePredicate((CharSet)sourceSet){
                final /* synthetic */ CharSet val$sourceSet;
                {
                    this.val$sourceSet = charSet;
                }

                public boolean accept(char key, double value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                CharDoubleHashMap.access$802(CharDoubleHashMap.this, retained.keys);
                CharDoubleHashMap.access$1002(CharDoubleHashMap.this, retained.values);
                CharDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                CharDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll((CharIterable)CharHashSet.newSetWith(source));
        }

        public void clear() {
            CharDoubleHashMap.this.clear();
        }

        public MutableCharSet select(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet reject(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet with(char element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet without(char element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet withAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf('\u0000'));
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf('\u0001'));
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableCharSet asUnmodifiable() {
            return UnmodifiableCharSet.of(this);
        }

        public MutableCharSet asSynchronized() {
            return SynchronizedCharSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (char key : CharDoubleHashMap.this.keys) {
                if (!CharDoubleHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public char max() {
            if (CharDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char max = '\u0000';
            boolean isMaxSet = false;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    max = '\u0000';
                    isMaxSet = true;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < '\u0001')) {
                    max = '\u0001';
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i]) || isMaxSet && max >= CharDoubleHashMap.this.keys[i]) continue;
                max = CharDoubleHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public char maxIfEmpty(char defaultValue) {
            if (CharDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public char min() {
            if (CharDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char min = '\u0000';
            boolean isMinSet = false;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    min = '\u0000';
                    isMinSet = true;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey && (!isMinSet || '\u0001' < min)) {
                    min = '\u0001';
                    isMinSet = true;
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i]) || isMinSet && CharDoubleHashMap.this.keys[i] >= min) continue;
                min = CharDoubleHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public char minIfEmpty(char defaultValue) {
            if (CharDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableCharList toSortedList() {
            return CharArrayList.newList((CharIterable)this).sortThis();
        }

        public char[] toArray() {
            int size = CharDoubleHashMap.this.size();
            final char[] result = new char[size];
            CharDoubleHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(char value) {
            return CharDoubleHashMap.this.containsKey(value);
        }

        public boolean containsAll(char ... source) {
            for (char item : source) {
                if (CharDoubleHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(CharIterable source) {
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                if (CharDoubleHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, '\u0000');
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, '\u0001');
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                result = function.valueOf(result, CharDoubleHashMap.this.keys[i]);
            }
            return result;
        }

        public CharSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableCharSet toImmutable() {
            return CharSets.immutable.withAll((CharIterable)this);
        }

        public int size() {
            return CharDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return CharDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharDoubleHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CharSet)) {
                return false;
            }
            CharSet other = (CharSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                result += CharDoubleHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharDoubleHashMap.this.sentinelValues != null) {
                    if (CharDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharDoubleHashMap.this.keys) {
                    if (!CharDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharDoubleHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharDoubleHashMap.this.containsKey('\u0000')) {
                    return '\u0000';
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharDoubleHashMap.this.containsKey('\u0001')) {
                    return '\u0001';
                }
            }
            char[] keys = CharDoubleHashMap.this.keys;
            while (!CharDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharDoubleHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalDoubleIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < CharDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharDoubleHashMap.this.containsKey('\u0000')) {
                    return CharDoubleHashMap.this.get('\u0000');
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharDoubleHashMap.this.containsKey('\u0001')) {
                    return CharDoubleHashMap.this.get('\u0001');
                }
            }
            char[] keys = CharDoubleHashMap.this.keys;
            while (!CharDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = CharDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private double zeroValue;
        private double oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(double value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Double.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Double.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

