/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.bag;

import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.multimap.bag.ImmutableBagMultimap;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.impl.block.procedure.checked.CheckedObjectIntProcedure;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.multimap.AbstractImmutableMultimap;
import com.gs.collections.impl.multimap.bag.HashBagMultimap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableBagMultimapImpl<K, V>
extends AbstractImmutableMultimap<K, V, ImmutableBag<V>>
implements ImmutableBagMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    public ImmutableBagMultimapImpl(MutableMap<K, ImmutableBag<V>> map) {
        super(map);
    }

    public ImmutableBagMultimapImpl(ImmutableMap<K, ImmutableBag<V>> map) {
        super(map);
    }

    @Override
    protected ImmutableBag<V> createCollection() {
        return Bags.immutable.of();
    }

    public ImmutableBagMultimap<K, V> newEmpty() {
        return new ImmutableBagMultimapImpl<K, V>(Maps.immutable.of());
    }

    public MutableBagMultimap<K, V> toMutable() {
        return new HashBagMultimap(this);
    }

    @Override
    public ImmutableBagMultimap<K, V> toImmutable() {
        return this;
    }

    private Object writeReplace() {
        return new ImmutableBagMultimapSerializationProxy(this.map);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWith(K key, V value) {
        return (ImmutableBagMultimap)super.newWith(key, value);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWithout(Object key, Object value) {
        return (ImmutableBagMultimap)super.newWithout(key, value);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWithAll(K key, Iterable<? extends V> values) {
        return (ImmutableBagMultimap)super.newWithAll(key, values);
    }

    @Override
    public ImmutableBagMultimap<K, V> newWithoutAll(Object key) {
        return (ImmutableBagMultimap)super.newWithoutAll(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableBagMultimapSerializationProxy<K, V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ImmutableMap<K, ImmutableBag<V>> map;
        private MutableMultimap<K, V> multimap;

        public ImmutableBagMultimapSerializationProxy() {
        }

        private ImmutableBagMultimapSerializationProxy(ImmutableMap<K, ImmutableBag<V>> map) {
            this.map = map;
        }

        protected Object readResolve() {
            return this.multimap.toImmutable();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.multimap = new HashBagMultimap();
            int keyCount = in.readInt();
            for (int i = 0; i < keyCount; ++i) {
                Object key = in.readObject();
                int valuesSize = in.readInt();
                MutableBag bag = Bags.mutable.of();
                for (int j = 0; j < valuesSize; ++j) {
                    Object value = in.readObject();
                    int count = in.readInt();
                    bag.addOccurrences(value, count);
                }
                this.multimap.putAll(key, (Iterable)bag);
            }
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            int keysCount = this.map.size();
            out.writeInt(keysCount);
            this.map.forEachKeyValue((Procedure2)new CheckedProcedure2<K, ImmutableBag<V>>(){

                @Override
                public void safeValue(K key, ImmutableBag<V> bag) throws IOException {
                    out.writeObject(key);
                    out.writeInt(bag.sizeDistinct());
                    bag.forEachWithOccurrences((ObjectIntProcedure)new CheckedObjectIntProcedure<V>(){

                        @Override
                        public void safeValue(V value, int count) throws IOException {
                            out.writeObject(value);
                            out.writeInt(count);
                        }
                    });
                }
            });
        }
    }
}

