/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableDoubleSetFactory;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableDoubleEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableDoubleSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;

public class ImmutableDoubleSetFactoryImpl
implements ImmutableDoubleSetFactory {
    public ImmutableDoubleSet of() {
        return this.with();
    }

    public ImmutableDoubleSet with() {
        return ImmutableDoubleEmptySet.INSTANCE;
    }

    public ImmutableDoubleSet of(double one) {
        return this.with(one);
    }

    public ImmutableDoubleSet with(double one) {
        return new ImmutableDoubleSingletonSet(one);
    }

    public ImmutableDoubleSet of(double ... items) {
        return this.with(items);
    }

    public ImmutableDoubleSet with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return DoubleHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableDoubleSet ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public ImmutableDoubleSet withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleSet) {
            return (ImmutableDoubleSet)items;
        }
        return this.with(items.toArray());
    }
}

