/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationIndexer;
import org.grails.datastore.mapping.model.PersistentEntity;

public abstract class AbstractPersistentCollection
implements PersistentCollection,
Serializable {
    private transient Session session;
    private transient AssociationIndexer indexer;
    private transient Class childType;
    private boolean initialized;
    private Serializable associationKey;
    private Collection keys;
    private boolean dirty = false;
    protected final Collection collection;

    protected AbstractPersistentCollection(Class childType, Session session, Collection collection) {
        this.childType = childType;
        this.collection = collection;
        this.session = session;
    }

    protected AbstractPersistentCollection(Collection keys, Class childType, Session session, Collection collection) {
        this.session = session;
        this.keys = keys;
        this.childType = childType;
        this.collection = collection;
    }

    protected AbstractPersistentCollection(Serializable associationKey, Session session, AssociationIndexer indexer, Collection collection) {
        this.session = session;
        this.associationKey = associationKey;
        this.indexer = indexer;
        this.collection = collection;
    }

    @Override
    public Iterator iterator() {
        this.initialize();
        final Iterator iterator = this.collection.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                AbstractPersistentCollection.this.markDirty();
            }
        };
    }

    @Override
    public int size() {
        this.initialize();
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.initialize();
        return this.collection.contains(o);
    }

    public boolean add(Object o) {
        this.initialize();
        boolean added = this.collection.add(o);
        if (added) {
            this.markDirty();
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        this.initialize();
        boolean remove = this.collection.remove(o);
        if (remove) {
            this.markDirty();
        }
        return remove;
    }

    @Override
    public void clear() {
        this.initialize();
        this.collection.clear();
        this.markDirty();
    }

    @Override
    public boolean equals(Object o) {
        this.initialize();
        return this.collection.equals(o);
    }

    @Override
    public int hashCode() {
        this.initialize();
        return this.collection.hashCode();
    }

    public String toString() {
        this.initialize();
        return this.collection.toString();
    }

    public boolean removeAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.removeAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        this.initialize();
        return this.collection.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.initialize();
        return this.collection.toArray(a);
    }

    public boolean containsAll(Collection c) {
        this.initialize();
        return this.collection.containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.addAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.retainAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.session == null) {
            throw new IllegalStateException("PersistentCollection of type " + this.getClass().getName() + " should have been initialized before serialization.");
        }
        this.initialized = true;
        if (this.associationKey == null) {
            if (this.keys != null) {
                this.addAll((Collection)this.session.retrieveAll(this.childType, this.keys));
            }
        } else {
            List results = this.indexer.query(this.associationKey);
            PersistentEntity entity = this.indexer.getIndexedEntity();
            if (entity != null) {
                this.addAll((Collection)this.session.retrieveAll(entity.getJavaClass(), results));
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void resetDirty() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }
}

