/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.config;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.config.groovy.MappingConfigurationBuilder;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.springframework.beans.BeanUtils;

public abstract class AbstractGormMappingFactory<R extends Entity, T extends Property>
extends MappingFactory<R, T> {
    protected Map<PersistentEntity, Map<String, T>> entityToPropertyMap = new HashMap<PersistentEntity, Map<String, T>>();
    private Closure defaultMapping;

    @Override
    public R createMappedForm(PersistentEntity entity) {
        Closure value;
        int i;
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entity.getJavaClass());
        Entity family = (Entity)BeanUtils.instantiate(this.getEntityMappedFormType());
        MappingConfigurationBuilder builder = new MappingConfigurationBuilder(family, this.getPropertyMappedFormType());
        if (this.defaultMapping != null) {
            builder.evaluate(this.defaultMapping);
        }
        List<Closure> values = cpf.getStaticPropertyValuesFromInheritanceHierarchy("mapping", Closure.class);
        for (i = values.size(); i > 0; --i) {
            value = values.get(i - 1);
            builder.evaluate(value);
        }
        values = cpf.getStaticPropertyValuesFromInheritanceHierarchy("constraints", Closure.class);
        for (i = values.size(); i > 0; --i) {
            value = values.get(i - 1);
            builder.evaluate(value);
        }
        this.entityToPropertyMap.put(entity, builder.getProperties());
        return (R)family;
    }

    public void setDefaultMapping(Closure defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    protected abstract Class<T> getPropertyMappedFormType();

    protected abstract Class<R> getEntityMappedFormType();

    @Override
    public IdentityMapping createIdentityMapping(ClassMapping classMapping) {
        Property property;
        IdentityMapping customIdentityMapping;
        Map<String, T> props = this.entityToPropertyMap.get(classMapping.getEntity());
        if (props != null && (customIdentityMapping = this.getIdentityMappedForm(classMapping, property = (Property)props.get("id"))) != null) {
            return customIdentityMapping;
        }
        return super.createIdentityMapping(classMapping);
    }

    protected IdentityMapping getIdentityMappedForm(ClassMapping classMapping, T property) {
        return null;
    }

    @Override
    public T createMappedForm(PersistentProperty mpp) {
        Property defaultMapping;
        Property property;
        Map<String, T> properties = this.entityToPropertyMap.get(mpp.getOwner());
        if (properties != null && properties.containsKey(mpp.getName())) {
            return (T)((Property)properties.get(mpp.getName()));
        }
        if (properties != null && (property = (Property)properties.get("id")) != null && mpp.getName().equals(property.getName())) {
            return (T)property;
        }
        Property property2 = defaultMapping = properties != null ? (Property)properties.get("*") : null;
        if (defaultMapping != null) {
            try {
                return (T)defaultMapping.clone();
            }
            catch (CloneNotSupportedException e) {
                return (T)((Property)BeanUtils.instantiate(this.getPropertyMappedFormType()));
            }
        }
        return (T)((Property)BeanUtils.instantiate(this.getPropertyMappedFormType()));
    }
}

